/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb;

import java.util.HashMap;
import java.util.Map;
import org.iternine.jeppetto.dao.EntityVelocityEnhancer;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBPersistable;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBUpdateObjectHelper;
import org.iternine.jeppetto.dao.updateobject.UpdateObject;
import org.iternine.jeppetto.dao.updateobject.UpdateObjectVelocityEnhancer;
import org.iternine.jeppetto.enhance.Enhancer;
import org.iternine.jeppetto.enhance.NoOpEnhancer;

public class EnhancerHelper {
    private static final Map<Class, Enhancer> persistableEnhancers = new HashMap<Class, Enhancer>();
    private static final Map<Class, Enhancer> updateObjectEnhancers = new HashMap<Class, Enhancer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Enhancer<T> getPersistableEnhancer(Class<T> baseClass) {
        if (persistableEnhancers.containsKey(baseClass)) {
            return persistableEnhancers.get(baseClass);
        }
        Map<Class, Enhancer> map = persistableEnhancers;
        synchronized (map) {
            Object enhancer = persistableEnhancers.get(baseClass);
            if (enhancer != null) {
                return enhancer;
            }
            enhancer = DynamoDBPersistable.class.isAssignableFrom(baseClass) ? new NoOpEnhancer(baseClass) : new EntityVelocityEnhancer<T>(baseClass){

                public boolean needsEnhancement(Object object) {
                    return object != null && !(object instanceof DynamoDBPersistable);
                }

                protected String getTemplateLocation() {
                    return "org/iternine/jeppetto/dao/dynamodb/enhance/dynamoDBPersistable.vm";
                }
            };
            persistableEnhancers.put(baseClass, (Enhancer)enhancer);
            return enhancer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Enhancer<T> getUpdateObjectEnhancer(Class<T> baseClass) {
        if (updateObjectEnhancers.containsKey(baseClass)) {
            return updateObjectEnhancers.get(baseClass);
        }
        Map<Class, Enhancer> map = updateObjectEnhancers;
        synchronized (map) {
            Object enhancer = updateObjectEnhancers.get(baseClass);
            if (enhancer != null) {
                return enhancer;
            }
            enhancer = UpdateObject.class.isAssignableFrom(baseClass) ? new NoOpEnhancer(baseClass) : new UpdateObjectVelocityEnhancer<T>(baseClass){

                public boolean needsEnhancement(Object object) {
                    return object != null && !(object instanceof UpdateObject);
                }

                protected String getTemplateLocation() {
                    return "org/iternine/jeppetto/dao/enhance/updateObject.vm";
                }

                protected Map<String, Object> getAdditionalContextItems() {
                    Map contextItems = super.getAdditionalContextItems();
                    contextItems.put("updateObjectHelper", new DynamoDBUpdateObjectHelper());
                    return contextItems;
                }
            };
            updateObjectEnhancers.put(baseClass, (Enhancer)enhancer);
            return enhancer;
        }
    }
}

