/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.expression;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.QueryModel;
import org.iternine.jeppetto.dao.dynamodb.ConversionUtil;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBConstraint;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBOperator;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBQueryModelDAO;
import org.iternine.jeppetto.dao.dynamodb.expression.ExpressionBuilder;

public class ConditionExpressionBuilder
extends ExpressionBuilder {
    private static final Map<DynamoDBOperator, String> OPERATOR_EXPRESSIONS = new HashMap<DynamoDBOperator, String>(11){
        {
            this.put(DynamoDBOperator.NotEqual, "%s <> %s");
            this.put(DynamoDBOperator.GreaterThanEqual, "%s >= %s");
            this.put(DynamoDBOperator.LessThanEqual, "%s <= %s");
            this.put(DynamoDBOperator.Equal, "%s = %s");
            this.put(DynamoDBOperator.GreaterThan, "%s > %s");
            this.put(DynamoDBOperator.LessThan, "%s < %s");
            this.put(DynamoDBOperator.NotWithin, "NOT %s IN %s");
            this.put(DynamoDBOperator.Within, "%s IN %s");
            this.put(DynamoDBOperator.Between, "%s BETWEEN %s AND %s");
            this.put(DynamoDBOperator.IsNull, "attribute_not_exists(%s)");
            this.put(DynamoDBOperator.IsNotNull, "attribute_exists(%s)");
            this.put(DynamoDBOperator.BeginsWith, "begins_with(%s, %s)");
        }
    };
    private static final Set<ComparisonOperator> RANGE_KEY_COMPARISON_OPERATORS = new HashSet<ComparisonOperator>(7){
        {
            this.add(ComparisonOperator.EQ);
            this.add(ComparisonOperator.LE);
            this.add(ComparisonOperator.LT);
            this.add(ComparisonOperator.GE);
            this.add(ComparisonOperator.GT);
            this.add(ComparisonOperator.BEGINS_WITH);
            this.add(ComparisonOperator.BETWEEN);
        }
    };
    private static final String EXPRESSION_ATTRIBUTE_VALUE_PREFIX = ":c";
    private static final String EXPRESSION_ATTRIBUTE_NAME_PREFIX = "#c";
    private Condition hashKeyCondition;
    private Condition rangeKeyCondition;
    private final StringBuilder expression = new StringBuilder();

    public ConditionExpressionBuilder() {
        super(true);
    }

    public ConditionExpressionBuilder(QueryModel queryModel, Map<String, Map<String, DynamoDBQueryModelDAO.IndexData>> indexes) {
        super(true);
        if (queryModel.getConditions() != null) {
            for (Condition condition : queryModel.getConditions()) {
                DynamoDBConstraint dynamoDBConstraint = (DynamoDBConstraint)condition.getConstraint();
                ComparisonOperator comparisonOperator = dynamoDBConstraint.getOperator().getComparisonOperator();
                if (indexes.containsKey(condition.getField()) && comparisonOperator == ComparisonOperator.EQ) {
                    this.hashKeyCondition = condition;
                    continue;
                }
                if (this.hashKeyCondition != null && this.rangeKeyCondition == null && indexes.get(this.hashKeyCondition.getField()).containsKey(condition.getField()) && RANGE_KEY_COMPARISON_OPERATORS.contains(comparisonOperator)) {
                    this.rangeKeyCondition = condition;
                    continue;
                }
                this.add(this.getExpressionAttributeName(condition.getField()), dynamoDBConstraint);
            }
        }
        if (queryModel.getAssociationConditions() != null) {
            for (Map.Entry entry : queryModel.getAssociationConditions().entrySet()) {
                for (Condition condition : (List)entry.getValue()) {
                    this.add(this.getExpressionAttributeName((String)entry.getKey(), condition.getField()), (DynamoDBConstraint)condition.getConstraint());
                }
            }
        }
    }

    @Override
    public boolean hasExpression() {
        return this.expression.length() > 0;
    }

    @Override
    public String getExpression() {
        return this.expression.toString();
    }

    @Override
    public String getExpressionAttributeValuePrefix() {
        return EXPRESSION_ATTRIBUTE_VALUE_PREFIX;
    }

    @Override
    public String getExpressionAttributeNamePrefix() {
        return EXPRESSION_ATTRIBUTE_NAME_PREFIX;
    }

    public boolean hasHashKeyCondition() {
        return this.hashKeyCondition != null;
    }

    public Map<String, com.amazonaws.services.dynamodbv2.model.Condition> getKeyConditions() {
        if (this.rangeKeyCondition == null) {
            return Collections.singletonMap(this.hashKeyCondition.getField(), ((DynamoDBConstraint)this.hashKeyCondition.getConstraint()).asCondition());
        }
        HashMap<String, com.amazonaws.services.dynamodbv2.model.Condition> keyConditions = new HashMap<String, com.amazonaws.services.dynamodbv2.model.Condition>();
        keyConditions.put(this.hashKeyCondition.getField(), ((DynamoDBConstraint)this.hashKeyCondition.getConstraint()).asCondition());
        keyConditions.put(this.rangeKeyCondition.getField(), ((DynamoDBConstraint)this.rangeKeyCondition.getConstraint()).asCondition());
        return keyConditions;
    }

    public String getHashKey() {
        if (this.hashKeyCondition == null) {
            return null;
        }
        return this.hashKeyCondition.getField();
    }

    public String getRangeKey() {
        if (this.rangeKeyCondition == null) {
            return null;
        }
        return this.rangeKeyCondition.getField();
    }

    public void convertRangeKeyConditionToExpression() {
        if (this.rangeKeyCondition == null) {
            return;
        }
        this.add(this.getExpressionAttributeName(this.rangeKeyCondition.getField()), (DynamoDBConstraint)this.rangeKeyCondition.getConstraint());
    }

    public Map<String, AttributeValue> getKey() {
        HashMap<String, AttributeValue> key;
        if (this.rangeKeyCondition == null) {
            key = Collections.singletonMap(this.hashKeyCondition.getField(), ConversionUtil.toAttributeValue(((DynamoDBConstraint)this.hashKeyCondition.getConstraint()).getValues()[0]));
        } else {
            key = new HashMap<String, AttributeValue>(2);
            key.put(this.hashKeyCondition.getField(), ConversionUtil.toAttributeValue(((DynamoDBConstraint)this.hashKeyCondition.getConstraint()).getValues()[0]));
            key.put(this.rangeKeyCondition.getField(), ConversionUtil.toAttributeValue(((DynamoDBConstraint)this.rangeKeyCondition.getConstraint()).getValues()[0]));
        }
        return key;
    }

    public ConditionExpressionBuilder with(String field, DynamoDBConstraint constraint) {
        this.add(this.getExpressionAttributeName(field), constraint);
        return this;
    }

    private String getExpressionAttributeName(String association, String attributeName) {
        StringBuilder sb = new StringBuilder();
        if (association.contains(".")) {
            String[] associationParts;
            for (String associationPart : associationParts = association.split(".")) {
                sb.append(this.getExpressionAttributeName(associationPart));
                sb.append('.');
            }
        } else {
            sb.append(this.getExpressionAttributeName(association));
            sb.append('.');
        }
        return sb.append(this.getExpressionAttributeName(attributeName)).toString();
    }

    private void add(String expressionAttributeName, DynamoDBConstraint constraint) {
        if (this.expression.length() > 0) {
            this.expression.append(" and ");
        }
        String operatorExpression = OPERATOR_EXPRESSIONS.get((Object)constraint.getOperator());
        int argumentCount = constraint.getOperator().getArgumentCount();
        Object[] values = constraint.getValues();
        if (argumentCount == 0) {
            this.expression.append(String.format(operatorExpression, expressionAttributeName));
        } else if (argumentCount == 1) {
            String expressionAttributeKey = this.putExpressionAttributeValue(ConversionUtil.toAttributeValue(values[0]));
            this.expression.append(String.format(operatorExpression, expressionAttributeName, expressionAttributeKey));
        } else if (argumentCount == 2) {
            String expressionAttributeKey0 = this.putExpressionAttributeValue(ConversionUtil.toAttributeValue(values[0]));
            String expressionAttributeKey1 = this.putExpressionAttributeValue(ConversionUtil.toAttributeValue(values[1]));
            this.expression.append(String.format(operatorExpression, expressionAttributeName, expressionAttributeKey0, expressionAttributeKey1));
        } else {
            StringBuilder placeholders = new StringBuilder("(");
            Collection<AttributeValue> attributeValues = ConversionUtil.toAttributeValueList(values[0]);
            for (AttributeValue attributeValue : attributeValues) {
                if (placeholders.length() > 1) {
                    placeholders.append(", ");
                }
                String expressionAttributeKey = this.putExpressionAttributeValue(attributeValue);
                placeholders.append(expressionAttributeKey);
            }
            placeholders.append(')');
            this.expression.append(String.format(operatorExpression, expressionAttributeName, placeholders.toString()));
        }
    }
}

