/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.expression;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.iternine.jeppetto.dao.dynamodb.expression.DynamoDBReservedWords;

public abstract class ExpressionBuilder {
    private Map<String, AttributeValue> expressionAttributeValues;
    private Map<String, String> expressionAttributeNames = new HashMap<String, String>();
    private int expressionAttributeValueCounter = 0;
    private int expressionAttributeNameCounter = 0;

    protected ExpressionBuilder(boolean expressionAttributesExpected) {
        this.expressionAttributeValues = expressionAttributesExpected ? new HashMap() : Collections.emptyMap();
    }

    public abstract boolean hasExpression();

    public abstract String getExpression();

    public abstract String getExpressionAttributeValuePrefix();

    public abstract String getExpressionAttributeNamePrefix();

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    protected String putExpressionAttributeValue(AttributeValue expressionAttributeValue) {
        String expressionAttributeValueKey = this.getExpressionAttributeValuePrefix() + this.expressionAttributeValueCounter++;
        this.expressionAttributeValues.put(expressionAttributeValueKey, expressionAttributeValue);
        return expressionAttributeValueKey;
    }

    protected String getExpressionAttributeName(String attributeName) {
        if (DynamoDBReservedWords.isReserved(attributeName)) {
            if (this.expressionAttributeNames.containsKey(attributeName)) {
                return this.expressionAttributeNames.get(attributeName);
            }
            String expressionAttributeName = this.getExpressionAttributeNamePrefix() + this.expressionAttributeNameCounter++;
            this.expressionAttributeNames.put(expressionAttributeName, attributeName);
            return expressionAttributeName;
        }
        return attributeName;
    }
}

