/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.expression;

import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.iternine.jeppetto.dao.annotation.Transient;
import org.iternine.jeppetto.dao.dynamodb.expression.ExpressionBuilder;

public class ProjectionExpressionBuilder
extends ExpressionBuilder {
    private static final Set<Class<?>> DIRECTLY_PROJECTED_TYPES = new HashSet<Class<?>>(){
        {
            this.add(Date.class);
            this.add(Boolean.TYPE);
            this.add(Character.TYPE);
            this.add(Byte.TYPE);
            this.add(Short.TYPE);
            this.add(Integer.TYPE);
            this.add(Long.TYPE);
            this.add(Float.TYPE);
            this.add(Double.TYPE);
            this.add(Number.class);
            this.add(BigDecimal.class);
            this.add(BigInteger.class);
            this.add(String.class);
            this.add(Boolean.class);
            this.add(Character.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
        }
    };
    private static final String EXPRESSION_ATTRIBUTE_NAME_PREFIX = "#p";
    private final Set<String> nonKeyAttributes;
    private final String expression;

    public ProjectionExpressionBuilder(Class<?> entityClass, String hashKeyField, String rangeKeyField, String optimisticLockField) {
        super(false);
        this.nonKeyAttributes = this.collectFields(entityClass, "", new HashSet<String>());
        this.nonKeyAttributes.remove(hashKeyField);
        this.nonKeyAttributes.remove(rangeKeyField);
        if (optimisticLockField != null) {
            this.nonKeyAttributes.add(optimisticLockField);
        }
        StringBuilder expressionStringBuilder = new StringBuilder(this.getExpressionAttributeName(hashKeyField));
        if (rangeKeyField != null) {
            expressionStringBuilder.append(", ").append(this.getExpressionAttributeName(rangeKeyField));
        }
        for (String nonKeyAttribute : this.nonKeyAttributes) {
            expressionStringBuilder.append(", ").append(nonKeyAttribute);
        }
        this.expression = expressionStringBuilder.toString();
    }

    @Override
    public boolean hasExpression() {
        return this.expression.length() > 0;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getExpressionAttributeValuePrefix() {
        throw new RuntimeException("Should not be called");
    }

    @Override
    public String getExpressionAttributeNamePrefix() {
        return EXPRESSION_ATTRIBUTE_NAME_PREFIX;
    }

    public Boolean isCoveredBy(Projection projection) {
        switch (ProjectionType.valueOf((String)projection.getProjectionType())) {
            case ALL: {
                return Boolean.TRUE;
            }
            case KEYS_ONLY: {
                return this.nonKeyAttributes.isEmpty();
            }
            case INCLUDE: {
                return projection.getNonKeyAttributes().containsAll(this.nonKeyAttributes);
            }
        }
        return Boolean.FALSE;
    }

    private Set<String> collectFields(Class clazz, String fieldPrefix, Set<String> fields) {
        Map<String, Class> fieldsAndClasses = this.getFieldsAndClasses(clazz, fieldPrefix);
        for (Map.Entry<String, Class> entry : fieldsAndClasses.entrySet()) {
            String field = entry.getKey();
            Class fieldClass = entry.getValue();
            if (DIRECTLY_PROJECTED_TYPES.contains(fieldClass) || Collection.class.isAssignableFrom(fieldClass)) {
                fields.add(field);
                continue;
            }
            this.collectFields(fieldClass, field + ".", fields);
        }
        return fields;
    }

    private Map<String, Class> getFieldsAndClasses(Class clazz, String fieldPrefix) {
        HashMap<String, Class> fieldMap = new HashMap<String, Class>();
        ArrayList methods = new ArrayList();
        Collections.addAll(methods, clazz.getDeclaredMethods());
        Collections.addAll(methods, clazz.getMethods());
        for (Method method : methods) {
            String upperCaseFieldName;
            if (method.getDeclaringClass().equals(Object.class) || method.getReturnType().equals(Void.TYPE) || Modifier.isFinal(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getAnnotation(Transient.class) != null) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                upperCaseFieldName = methodName.substring(3);
            } else {
                if (!methodName.startsWith("is")) continue;
                upperCaseFieldName = methodName.substring(2);
            }
            try {
                clazz.getMethod("set".concat(upperCaseFieldName), method.getReturnType());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            String field = upperCaseFieldName.substring(0, 1).toLowerCase().concat(upperCaseFieldName.substring(1));
            fieldMap.put(fieldPrefix + this.getExpressionAttributeName(field), method.getReturnType());
        }
        return fieldMap;
    }
}

