/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.expression;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.iternine.jeppetto.dao.dynamodb.ConversionUtil;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBPersistable;
import org.iternine.jeppetto.dao.dynamodb.expression.ExpressionBuilder;
import org.iternine.jeppetto.dao.persistable.PersistableList;
import org.iternine.jeppetto.dao.persistable.PersistableMap;
import org.iternine.jeppetto.dao.updateobject.NumericIncrement;
import org.iternine.jeppetto.dao.updateobject.UpdateList;
import org.iternine.jeppetto.dao.updateobject.UpdateMap;
import org.iternine.jeppetto.dao.updateobject.UpdateObject;

public class UpdateExpressionBuilder
extends ExpressionBuilder {
    private static final String EXPRESSION_ATTRIBUTE_VALUE_PREFIX = ":u";
    private static final String EXPRESSION_ATTRIBUTE_NAME_PREFIX = "#u";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\d+\\]");
    private final StringBuilder setExpression = new StringBuilder();
    private final StringBuilder removeExpression = new StringBuilder();

    public UpdateExpressionBuilder(DynamoDBPersistable dynamoDBPersistable) {
        super(true);
        this.extractUpdateDetails(dynamoDBPersistable, "");
    }

    public UpdateExpressionBuilder(UpdateObject updateObject) {
        super(true);
        this.extractUpdateDetails(updateObject, "");
    }

    @Override
    public boolean hasExpression() {
        return this.setExpression.length() > 0 || this.removeExpression.length() > 0;
    }

    @Override
    public String getExpression() {
        StringBuilder expression = new StringBuilder();
        if (this.setExpression.length() > 0) {
            expression.append("SET ");
            expression.append((CharSequence)this.setExpression);
        }
        if (this.removeExpression.length() > 0) {
            if (expression.length() > 0) {
                expression.append(' ');
            }
            expression.append("REMOVE ");
            expression.append((CharSequence)this.removeExpression);
        }
        return expression.toString();
    }

    @Override
    public String getExpressionAttributeValuePrefix() {
        return EXPRESSION_ATTRIBUTE_VALUE_PREFIX;
    }

    @Override
    public String getExpressionAttributeNamePrefix() {
        return EXPRESSION_ATTRIBUTE_NAME_PREFIX;
    }

    private void extractUpdateDetails(DynamoDBPersistable dynamoDBPersistable, String prefix) {
        Iterator dirtyFields = dynamoDBPersistable.__getDirtyFields();
        while (dirtyFields.hasNext()) {
            String dirtyField = (String)dirtyFields.next();
            this.processDirtyObject(dynamoDBPersistable.__get(dirtyField), prefix + this.getExpressionAttributeName(dirtyField));
        }
    }

    private void extractUpdateDetails(PersistableMap persistableMap, String prefix) {
        Iterator dirtyFields = persistableMap.__getDirtyFields();
        while (dirtyFields.hasNext()) {
            String dirtyField = (String)dirtyFields.next();
            this.processDirtyObject(persistableMap.get((Object)dirtyField), prefix + this.getExpressionAttributeName(dirtyField));
        }
    }

    private void extractUpdateDetails(PersistableList persistableList, String prefix) {
        if (persistableList.isRewrite()) {
            persistableList.__markPersisted(null);
            this.addToSetExpression(persistableList, prefix);
            return;
        }
        Iterator dirtyIndexes = persistableList.__getDirtyFields();
        while (dirtyIndexes.hasNext()) {
            int dirtyIndex = Integer.parseInt((String)dirtyIndexes.next());
            this.processDirtyObject(persistableList.get(dirtyIndex), prefix + '[' + dirtyIndex + ']');
        }
    }

    private void processDirtyObject(Object dirtyObject, String fullyQualifiedField) {
        if (dirtyObject == null) {
            this.append(this.removeExpression, fullyQualifiedField);
        } else if (PersistableList.class.isAssignableFrom(dirtyObject.getClass())) {
            this.extractUpdateDetails((PersistableList)dirtyObject, fullyQualifiedField);
        } else if (PersistableMap.class.isAssignableFrom(dirtyObject.getClass())) {
            this.extractUpdateDetails((PersistableMap)dirtyObject, fullyQualifiedField + ".");
        } else if (DynamoDBPersistable.class.isAssignableFrom(dirtyObject.getClass())) {
            this.extractUpdateDetails((DynamoDBPersistable)dirtyObject, fullyQualifiedField + ".");
        } else {
            this.addToSetExpression(dirtyObject, fullyQualifiedField);
        }
    }

    private void extractUpdateDetails(UpdateObject updateObject, String prefix) {
        for (Map.Entry updateEntry : updateObject.__getUpdates().entrySet()) {
            String field = (String)updateEntry.getKey();
            String fullyQualifiedField = prefix != null && !prefix.endsWith(".") && ARRAY_PATTERN.matcher(field).matches() ? prefix + field : prefix + this.getExpressionAttributeName(field);
            Object object = updateEntry.getValue();
            if (object == null) {
                this.append(this.removeExpression, fullyQualifiedField);
                continue;
            }
            if (UpdateList.class.isAssignableFrom(object.getClass())) {
                UpdateList updateList = (UpdateList)object;
                if (updateList.wasCleared()) {
                    this.addToSetExpression(updateList.getAdds(), fullyQualifiedField);
                    continue;
                }
                this.extractUpdateDetails((UpdateObject)updateList, fullyQualifiedField);
                if (updateList.getAdds().isEmpty()) continue;
                this.addListItemsToSetExpression(updateList.getAdds(), fullyQualifiedField);
                continue;
            }
            if (UpdateMap.class.isAssignableFrom(object.getClass())) {
                UpdateMap updateMap = (UpdateMap)object;
                if (updateMap.wasCleared()) {
                    this.addToSetExpression(updateMap, fullyQualifiedField);
                    continue;
                }
                this.extractUpdateDetails((UpdateObject)updateMap, fullyQualifiedField + ".");
                continue;
            }
            if (NumericIncrement.class.isAssignableFrom(object.getClass())) {
                this.addIncrementToSetExpression(((NumericIncrement)object).getIncrement(), fullyQualifiedField);
                continue;
            }
            if (UpdateObject.class.isAssignableFrom(object.getClass())) {
                this.extractUpdateDetails((UpdateObject)object, fullyQualifiedField + ".");
                continue;
            }
            this.addToSetExpression(object, fullyQualifiedField);
        }
    }

    private void addToSetExpression(Object object, String fullyQualifiedField) {
        String expressionAttributeValueKey = this.putExpressionAttributeValue(ConversionUtil.toAttributeValue(object));
        this.append(this.setExpression, fullyQualifiedField + " = " + expressionAttributeValueKey);
    }

    private void addListItemsToSetExpression(List<Object> adds, String fullyQualifiedField) {
        String expressionAttributeValueKey = this.putExpressionAttributeValue(ConversionUtil.toAttributeValue(adds));
        this.append(this.setExpression, fullyQualifiedField + " = list_append(" + fullyQualifiedField + ", " + expressionAttributeValueKey + ')');
    }

    private void addIncrementToSetExpression(Number number, String fullyQualifiedField) {
        String incrementString;
        String numberString = number.toString();
        if (numberString.charAt(0) == '-') {
            String expressionAttributeValueKey = this.putExpressionAttributeValue(new AttributeValue().withN(numberString.substring(1)));
            incrementString = " - " + expressionAttributeValueKey;
        } else {
            String expressionAttributeValueKey = this.putExpressionAttributeValue(new AttributeValue().withN(numberString));
            incrementString = " + " + expressionAttributeValueKey;
        }
        this.append(this.setExpression, fullyQualifiedField + " = " + fullyQualifiedField + incrementString);
    }

    private void append(StringBuilder sb, String text) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(text);
    }
}

