/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.iterable;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.dynamodb.iterable.DynamoDBIterable;
import org.iternine.jeppetto.dao.dynamodb.iterable.QueryIterable;
import org.iternine.jeppetto.enhance.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGetIterable<T>
extends DynamoDBIterable<T> {
    private BatchGetItemRequest batchGetItemRequest;
    private String tableName;
    private final Logger logger = LoggerFactory.getLogger(QueryIterable.class);

    public BatchGetIterable(AmazonDynamoDB dynamoDB, Enhancer<T> enhancer, BatchGetItemRequest batchGetItemRequest, String tableName) {
        super(dynamoDB, enhancer);
        this.batchGetItemRequest = batchGetItemRequest;
        this.tableName = tableName;
    }

    @Override
    protected void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        throw new JeppettoException("ExclusiveStartKey not used by BatchGet");
    }

    @Override
    protected Iterator<Map<String, AttributeValue>> fetchItems() {
        BatchGetItemResult currentBatchGetItemResult = this.getDynamoDB().batchGetItem(this.batchGetItemRequest);
        Iterator<Map<String, AttributeValue>> iterator = ((List)currentBatchGetItemResult.getResponses().get(this.tableName)).iterator();
        this.batchGetItemRequest.withRequestItems(currentBatchGetItemResult.getUnprocessedKeys());
        if (this.logger.isDebugEnabled()) {
            List consumedCapacities = currentBatchGetItemResult.getConsumedCapacity();
            this.logger.debug("Queried {} using {}.  Took {} read capacity units, retrieved {} items, more items {} available.", new Object[]{this.getEnhancer().getBaseClass().getSimpleName(), this.batchGetItemRequest, consumedCapacities == null ? null : (ConsumedCapacity)consumedCapacities.get(0), ((List)currentBatchGetItemResult.getResponses().get(this.tableName)).size(), currentBatchGetItemResult.getUnprocessedKeys() == null ? "are not" : "are"});
        }
        return iterator;
    }

    @Override
    protected boolean moreAvailable() {
        return this.batchGetItemRequest.getRequestItems() != null && this.batchGetItemRequest.getRequestItems().size() > 0;
    }

    @Override
    protected Collection<String> getKeyFields() {
        throw new JeppettoException("KeyFields not used by BatchGet");
    }

    @Override
    protected String getHashKeyField() {
        throw new JeppettoException("HashKeyField not used by BatchGet");
    }

    @Override
    public String getPosition(boolean removeHashKey) {
        if (removeHashKey) {
            throw new JeppettoException("BatchGetIterable doesn't support hash key removal.");
        }
        return super.getPosition(false);
    }
}

