/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.iterable;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.dynamodb.DynamoDBPersistable;
import org.iternine.jeppetto.enhance.Enhancer;

public abstract class DynamoDBIterable<T>
implements Iterable<T> {
    private AmazonDynamoDB dynamoDB;
    private Enhancer<T> enhancer;
    private int limit = -1;
    private DynamoDBIterator dynamoDBIterator;

    public DynamoDBIterable(AmazonDynamoDB dynamoDB, Enhancer<T> enhancer) {
        this.dynamoDB = dynamoDB;
        this.enhancer = enhancer;
    }

    protected abstract void setExclusiveStartKey(Map<String, AttributeValue> var1);

    protected abstract Iterator<Map<String, AttributeValue>> fetchItems();

    protected abstract boolean moreAvailable();

    protected abstract Collection<String> getKeyFields();

    protected abstract String getHashKeyField();

    @Override
    public Iterator<T> iterator() {
        this.dynamoDBIterator = new DynamoDBIterator(this.limit);
        return this.dynamoDBIterator;
    }

    public String getPosition() {
        return this.getPosition(false);
    }

    public String getPosition(boolean removeHashKey) {
        Map<String, AttributeValue> lastExaminedKey = this.getLastExaminedKey(removeHashKey);
        if (lastExaminedKey == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, AttributeValue> entry : lastExaminedKey.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(entry.getKey()).append('=').append(this.encode(entry.getValue()));
            }
            return URLEncoder.encode(Base64.encodeAsString((byte[])sb.toString().getBytes()), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPosition(String position) {
        this.setPosition(position, null);
    }

    public void setPosition(String position, String hashKeyValue) {
        if (this.dynamoDBIterator != null) {
            throw new JeppettoException("setPosition() only valid on a new DynamoDBIterable.");
        }
        if (position == null) {
            return;
        }
        try {
            byte[] decodedBytes = Base64.decode((String)URLDecoder.decode(position, StandardCharsets.UTF_8.name()));
            String[] attributePairs = new String(decodedBytes).split("&");
            if (attributePairs.length == 0) {
                return;
            }
            HashMap<String, AttributeValue> exclusiveStartKey = new HashMap<String, AttributeValue>();
            for (String attributePair : attributePairs) {
                String[] parts = attributePair.split("=");
                if (parts.length != 2) {
                    throw new JeppettoException("Corrupted position: " + position + "; found attribute: " + attributePair);
                }
                exclusiveStartKey.put(parts[0], this.decode(parts[1]));
            }
            if (hashKeyValue != null) {
                exclusiveStartKey.put(this.getHashKeyField(), new AttributeValue(hashKeyValue));
            }
            this.setExclusiveStartKey(exclusiveStartKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLimit(int limit) {
        if (this.dynamoDBIterator != null) {
            throw new JeppettoException("setLimit() only valid on a new DynamoDBIterable.");
        }
        if (limit < 1) {
            throw new JeppettoException("limit value must be a positive integer");
        }
        this.limit = limit;
    }

    public boolean hasResultsPastLimit() {
        if (this.limit == -1) {
            throw new JeppettoException("An iterable limit wasn't specified with setLimit()");
        }
        return this.dynamoDBIterator.hasNext0();
    }

    protected AmazonDynamoDB getDynamoDB() {
        return this.dynamoDB;
    }

    protected Enhancer<T> getEnhancer() {
        return this.enhancer;
    }

    private Map<String, AttributeValue> getLastExaminedKey(boolean removeHashKey) {
        HashMap<String, AttributeValue> generatedKey = new HashMap<String, AttributeValue>(this.getKeyFields().size());
        if (!this.dynamoDBIterator.hasNext0()) {
            return null;
        }
        for (String keyField : this.getKeyFields()) {
            if (removeHashKey && keyField.equals(this.getHashKeyField())) continue;
            generatedKey.put(keyField, (AttributeValue)this.dynamoDBIterator.getLastItem().get(keyField));
        }
        return generatedKey;
    }

    private String encode(AttributeValue attributeValue) throws UnsupportedEncodingException {
        String intermediate;
        if (attributeValue.getS() != null) {
            intermediate = "S" + attributeValue.getS();
        } else if (attributeValue.getN() != null) {
            intermediate = "N" + attributeValue.getN();
        } else {
            throw new JeppettoException("Can only handle 'S' and 'N' scalar types: " + attributeValue);
        }
        return URLEncoder.encode(intermediate, StandardCharsets.UTF_8.name());
    }

    private AttributeValue decode(String encoded) throws UnsupportedEncodingException {
        if (encoded.startsWith("S")) {
            return new AttributeValue().withS(URLDecoder.decode(encoded.substring(1), StandardCharsets.UTF_8.name()));
        }
        if (encoded.startsWith("N")) {
            return new AttributeValue().withN(URLDecoder.decode(encoded.substring(1), StandardCharsets.UTF_8.name()));
        }
        throw new JeppettoException("Can only handle 'S' and 'N' scalar types: " + encoded);
    }

    class DynamoDBIterator
    implements Iterator<T> {
        private Iterator<Map<String, AttributeValue>> iterator;
        private int remaining;
        private Map<String, AttributeValue> lastItem;

        DynamoDBIterator(int limit) {
            this.iterator = DynamoDBIterable.this.fetchItems();
            this.remaining = limit;
        }

        @Override
        public boolean hasNext() {
            return this.remaining != 0 && this.hasNext0();
        }

        @Override
        public T next() {
            if (this.remaining == 0) {
                throw new NoSuchElementException("Limit for query was reached.");
            }
            --this.remaining;
            this.lastItem = this.iterator.next();
            Object t = DynamoDBIterable.this.enhancer.newInstance();
            ((DynamoDBPersistable)t).__putAll(this.lastItem);
            ((DynamoDBPersistable)t).__markPersisted(DynamoDBIterable.this.dynamoDB.toString());
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean hasNext0() {
            if (this.iterator.hasNext()) {
                return true;
            }
            while (DynamoDBIterable.this.moreAvailable()) {
                this.iterator = DynamoDBIterable.this.fetchItems();
                if (!this.iterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        private Map<String, AttributeValue> getLastItem() {
            return this.lastItem;
        }
    }
}

