/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.iterable;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.iternine.jeppetto.dao.dynamodb.iterable.DynamoDBIterable;
import org.iternine.jeppetto.enhance.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIterable<T>
extends DynamoDBIterable<T> {
    private QueryRequest queryRequest;
    private String hashKeyField;
    private Collection<String> keyFields;
    private final Logger logger = LoggerFactory.getLogger(QueryIterable.class);

    public QueryIterable(AmazonDynamoDB dynamoDB, Enhancer<T> enhancer, QueryRequest queryRequest, String hashKeyField, Collection<String> keyFields) {
        super(dynamoDB, enhancer);
        this.queryRequest = queryRequest;
        this.hashKeyField = hashKeyField;
        this.keyFields = keyFields;
    }

    @Override
    protected void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.queryRequest.setExclusiveStartKey(exclusiveStartKey);
    }

    @Override
    protected Iterator<Map<String, AttributeValue>> fetchItems() {
        QueryResult currentQueryResult = this.getDynamoDB().query(this.queryRequest);
        Iterator<Map<String, AttributeValue>> iterator = currentQueryResult.getItems().iterator();
        this.queryRequest.setExclusiveStartKey(currentQueryResult.getLastEvaluatedKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Queried {} using {}.  Took {} read capacity units, retrieved {} items, more items {} available.", new Object[]{this.getEnhancer().getBaseClass().getSimpleName(), this.queryRequest, currentQueryResult.getConsumedCapacity(), currentQueryResult.getCount(), currentQueryResult.getLastEvaluatedKey() == null ? "are not" : "are"});
        }
        return iterator;
    }

    @Override
    protected boolean moreAvailable() {
        return this.queryRequest.getExclusiveStartKey() != null;
    }

    @Override
    protected Collection<String> getKeyFields() {
        return this.keyFields;
    }

    @Override
    protected String getHashKeyField() {
        return this.hashKeyField;
    }
}

