/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.dynamodb.iterable;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.dynamodb.iterable.DynamoDBIterable;
import org.iternine.jeppetto.enhance.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanIterable<T>
extends DynamoDBIterable<T> {
    private ScanRequest scanRequest;
    private Collection<String> keyFields;
    private final Logger logger = LoggerFactory.getLogger(ScanIterable.class);

    public ScanIterable(AmazonDynamoDB dynamoDB, Enhancer<T> enhancer, ScanRequest scanRequest, Collection<String> keyFields) {
        super(dynamoDB, enhancer);
        this.scanRequest = scanRequest;
        this.keyFields = keyFields;
    }

    @Override
    protected void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.scanRequest.setExclusiveStartKey(exclusiveStartKey);
    }

    @Override
    protected Iterator<Map<String, AttributeValue>> fetchItems() {
        ScanResult currentScanResult = this.getDynamoDB().scan(this.scanRequest);
        Iterator<Map<String, AttributeValue>> iterator = currentScanResult.getItems().iterator();
        this.scanRequest.setExclusiveStartKey(currentScanResult.getLastEvaluatedKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scanned {} using {}.  Took {} read capacity units, retrieved {} items, more items {} available.", new Object[]{this.getEnhancer().getBaseClass().getSimpleName(), this.scanRequest, currentScanResult.getConsumedCapacity(), currentScanResult.getCount(), currentScanResult.getLastEvaluatedKey() == null ? "are not" : "are"});
        }
        return iterator;
    }

    @Override
    protected boolean moreAvailable() {
        return this.scanRequest.getExclusiveStartKey() != null;
    }

    @Override
    protected Collection<String> getKeyFields() {
        return this.keyFields;
    }

    @Override
    protected String getHashKeyField() {
        throw new JeppettoException("HashKeyField not used by ScanIterable");
    }

    @Override
    public String getPosition(boolean removeHashKey) {
        if (removeHashKey) {
            throw new JeppettoException("ScanIterable doesn't support hash key removal.");
        }
        return super.getPosition(false);
    }
}

