/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.hibernate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.AccessControlException;
import org.iternine.jeppetto.dao.AccessType;
import org.iternine.jeppetto.dao.annotation.AccessControl;
import org.iternine.jeppetto.dao.annotation.Accessor;
import org.iternine.jeppetto.dao.hibernate.AccessControlEntry;

public class AccessControlHelper {
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    void createEntry(Class<?> objectType, Serializable id, String accessId, AccessType accessType) {
        if (accessType == AccessType.None) {
            return;
        }
        Session session = this.sessionFactory.getCurrentSession();
        AccessControlEntry accessControlEntry = new AccessControlEntry();
        accessControlEntry.setObjectType(objectType.getSimpleName());
        accessControlEntry.setObjectId(id.toString());
        accessControlEntry.setAccessibleBy(accessId);
        accessControlEntry.setAccessType(accessType.shortName());
        session.save((Object)accessControlEntry);
    }

    void deleteEntry(Class<?> objectType, Serializable id, String accessId) {
        Session session = this.sessionFactory.getCurrentSession();
        Criteria criteria = session.createCriteria(AccessControlEntry.class);
        criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
        criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
        criteria.add((Criterion)Restrictions.eq((String)"accessibleBy", (Object)accessId));
        for (Object o : criteria.list()) {
            session.delete(o);
        }
    }

    void deleteAllEntries(Class<?> objectType, Serializable id) {
        Session session = this.sessionFactory.getCurrentSession();
        Criteria criteria = session.createCriteria(AccessControlEntry.class);
        criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
        criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
        for (Object o : criteria.list()) {
            session.delete(o);
        }
    }

    Map<String, AccessType> getEntries(Class<?> objectType, Serializable id) {
        HashMap<String, AccessType> result = new HashMap<String, AccessType>();
        Session session = this.sessionFactory.getCurrentSession();
        Criteria criteria = session.createCriteria(AccessControlEntry.class);
        criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
        criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
        for (AccessControlEntry accessControlEntry : criteria.list()) {
            result.put(accessControlEntry.getAccessibleBy(), AccessType.getAccessTypeFromShortName((String)accessControlEntry.getAccessType()));
        }
        return result;
    }

    void validateContextAllows(Class<?> objectType, Serializable id, AccessControlContext accessControlContext, AccessType accessType) {
        if (this.annotationAllowsAccess(objectType, accessControlContext, accessType) || this.accessControlEntryAllows(objectType, id, accessControlContext.getAccessId(), accessType)) {
            return;
        }
        throw new AccessControlException("Can't access object [" + id + "] for " + accessType + " with " + accessControlContext);
    }

    boolean annotationAllowsAccess(Class<?> objectType, AccessControlContext accessControlContext, AccessType accessType) {
        if (accessType == null) {
            return false;
        }
        AccessControl accessControl = this.getAccessControlAnnotation(objectType);
        if (accessControl == null) {
            return false;
        }
        Set roles = accessControlContext.getRoles();
        for (Accessor accessor : accessControl.accessors()) {
            if (!accessor.access().allows(accessType) || accessor.type() != Accessor.Type.Anyone && (accessor.type() != Accessor.Type.Role || roles == null || !roles.contains(accessor.typeValue()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accessControlEntryAllows(Class<?> objectType, Serializable id, String accessId, AccessType accessType) {
        if (accessType == AccessType.None) {
            return false;
        }
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            Criteria criteria = session.createCriteria(AccessControlEntry.class);
            criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
            criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
            criteria.add((Criterion)Restrictions.eq((String)"accessibleBy", (Object)accessId));
            if (accessType == AccessType.Read) {
                criteria.add(Restrictions.in((String)"accessType", Arrays.asList(AccessType.Read.shortName(), AccessType.ReadWrite.shortName())));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"accessType", (Object)AccessType.ReadWrite.shortName()));
            }
            boolean bl = criteria.uniqueResult() != null;
            return bl;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (HibernateException ignore) {}
            }
        }
    }

    AccessControl getAccessControlAnnotation(Class<?> objectType) {
        while (objectType != null) {
            AccessControl accessControl = objectType.getAnnotation(AccessControl.class);
            if (accessControl != null) {
                return accessControl;
            }
            objectType = objectType.getSuperclass();
        }
        return null;
    }
}

