/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.hibernate;

import java.io.Serializable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.AccessControlException;
import org.iternine.jeppetto.dao.AccessType;
import org.iternine.jeppetto.dao.annotation.AccessControl;
import org.iternine.jeppetto.dao.annotation.Creator;
import org.iternine.jeppetto.dao.hibernate.AccessControlEntry;
import org.iternine.jeppetto.dao.hibernate.AccessControlHelper;

public class AccessControlInterceptor
extends EmptyInterceptor {
    private AccessControlHelper accessControlHelper;
    private AccessControlContextProvider accessControlContextProvider;

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (entity.getClass().isAssignableFrom(AccessControlEntry.class)) {
            return false;
        }
        this.accessControlHelper.validateContextAllows(entity.getClass(), id, this.accessControlContextProvider.getCurrent(), AccessType.ReadWrite);
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity.getClass().isAssignableFrom(AccessControlEntry.class)) {
            return false;
        }
        AccessControlContext accessControlContext = this.accessControlContextProvider.getCurrent();
        AccessControl accessControl = this.accessControlHelper.getAccessControlAnnotation(entity.getClass());
        if (accessControl != null) {
            block5: for (Creator creator : accessControl.creators()) {
                switch (creator.type()) {
                    case Identified: {
                        if (accessControlContext.getAccessId() == null) continue block5;
                        this.accessControlHelper.createEntry(entity.getClass(), id, accessControlContext.getAccessId(), creator.grantedAccess());
                        return false;
                    }
                    case Role: {
                        if (accessControlContext.getRoles() == null || !accessControlContext.getRoles().contains(creator.typeValue())) continue block5;
                        this.accessControlHelper.createEntry(entity.getClass(), id, accessControlContext.getAccessId(), creator.grantedAccess());
                        return false;
                    }
                    case Anonymous: {
                        return false;
                    }
                }
            }
            throw new AccessControlException("Unable to create " + entity.getClass().getSimpleName() + " with " + accessControlContext + ".  Check object's @AccessControl annotation.");
        }
        if (accessControlContext.getAccessId() != null) {
            this.accessControlHelper.createEntry(entity.getClass(), id, accessControlContext.getAccessId(), AccessType.ReadWrite);
        }
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (!entity.getClass().isAssignableFrom(AccessControlEntry.class)) {
            this.accessControlHelper.deleteAllEntries(entity.getClass(), id);
        }
    }

    public void setAccessControlHelper(AccessControlHelper accessControlHelper) {
        this.accessControlHelper = accessControlHelper;
    }

    public void setAccessControlContextProvider(AccessControlContextProvider accessControlContextProvider) {
        this.accessControlContextProvider = accessControlContextProvider;
    }
}

