/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.hibernate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.AccessControlException;
import org.iternine.jeppetto.dao.AccessType;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.annotation.AccessControl;
import org.iternine.jeppetto.dao.annotation.Accessor;
import org.iternine.jeppetto.dao.hibernate.AccessControlEntry;
import org.iternine.jeppetto.dao.hibernate.HibernateQueryModelDAO;

public class AccessControlHelper {
    private SessionFactory sessionFactory;
    private Map<Class, HibernateQueryModelDAO> daos = new HashMap<Class, HibernateQueryModelDAO>();

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    void registerDAO(Class<?> objectType, HibernateQueryModelDAO hibernateQueryModelDAO) {
        this.daos.put(objectType, hibernateQueryModelDAO);
    }

    void createEntry(Class<?> objectType, Serializable id, String accessId, AccessType accessType) {
        if (accessType == AccessType.None) {
            return;
        }
        Session session = this.sessionFactory.getCurrentSession();
        AccessControlEntry accessControlEntry = new AccessControlEntry();
        accessControlEntry.setObjectType(objectType.getSimpleName());
        accessControlEntry.setObjectId(id.toString());
        accessControlEntry.setAccessibleBy(accessId);
        accessControlEntry.setAccessType(accessType.shortName());
        session.save((Object)accessControlEntry);
    }

    void deleteEntry(Class<?> objectType, Serializable id, String accessId) {
        Session session = this.sessionFactory.getCurrentSession();
        Criteria criteria = session.createCriteria(AccessControlEntry.class);
        criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
        criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
        criteria.add((Criterion)Restrictions.eq((String)"accessibleBy", (Object)accessId));
        for (Object o : criteria.list()) {
            session.delete(o);
        }
    }

    void deleteAllEntries(Class<?> objectType, Serializable id) {
        Session session = this.sessionFactory.getCurrentSession();
        Criteria criteria = session.createCriteria(AccessControlEntry.class);
        criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
        criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
        for (Object o : criteria.list()) {
            session.delete(o);
        }
    }

    Map<String, AccessType> getEntries(Class<?> objectType, Serializable id) {
        Session session = this.sessionFactory.getCurrentSession();
        Criteria criteria = session.createCriteria(AccessControlEntry.class);
        criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
        criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
        List accessControlEntries = criteria.list();
        if (accessControlEntries == null || accessControlEntries.size() == 0) {
            return Collections.emptyMap();
        }
        if (accessControlEntries.size() == 1) {
            AccessControlEntry accessControlEntry = (AccessControlEntry)accessControlEntries.iterator().next();
            return Collections.singletonMap(accessControlEntry.getAccessibleBy(), AccessType.getAccessTypeFromShortName((String)accessControlEntry.getAccessType()));
        }
        HashMap<String, AccessType> result = new HashMap<String, AccessType>();
        for (AccessControlEntry accessControlEntry : accessControlEntries) {
            result.put(accessControlEntry.getAccessibleBy(), AccessType.getAccessTypeFromShortName((String)accessControlEntry.getAccessType()));
        }
        return result;
    }

    void validateContextAllowsWrite(Class<?> objectType, Serializable id, AccessControlContext accessControlContext, boolean checkIfReadable) {
        if (this.annotationAllowsAccess(objectType, accessControlContext, AccessType.ReadWrite) || this.accessControlEntryAllowsAccess(objectType, id, accessControlContext.getAccessId(), AccessType.ReadWrite)) {
            return;
        }
        if (checkIfReadable && !this.accessControlEntryAllowsAccess(objectType, id, accessControlContext.getAccessId(), AccessType.Read)) {
            throw new NoSuchItemException(objectType.getSimpleName(), id.toString());
        }
        throw new AccessControlException("Can't access object [" + id + "] for ReadWrite with " + accessControlContext);
    }

    boolean annotationAllowsAccess(Class<?> objectType, AccessControlContext accessControlContext, AccessType accessType) {
        if (accessType == null) {
            return false;
        }
        AccessControl accessControl = this.getAccessControlAnnotation(objectType);
        if (accessControl == null) {
            return false;
        }
        Set roles = accessControlContext.getRoles();
        for (Accessor accessor : accessControl.accessors()) {
            if (!accessor.access().allows(accessType) || accessor.type() != Accessor.Type.Anyone && (accessor.type() != Accessor.Type.Role || roles == null || !roles.contains(accessor.typeValue()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accessControlEntryAllowsAccess(Class<?> objectType, Serializable id, String accessId, AccessType accessType) {
        if (accessType == AccessType.None) {
            return false;
        }
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            Criteria criteria = session.createCriteria(AccessControlEntry.class);
            criteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)objectType.getSimpleName()));
            criteria.add((Criterion)Restrictions.eq((String)"objectId", (Object)id.toString()));
            criteria.add((Criterion)Restrictions.eq((String)"accessibleBy", (Object)accessId));
            if (accessType == AccessType.Read) {
                criteria.add(Restrictions.in((String)"accessType", Arrays.asList(AccessType.Read.shortName(), AccessType.ReadWrite.shortName())));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"accessType", (Object)AccessType.ReadWrite.shortName()));
            }
            boolean bl = criteria.uniqueResult() != null;
            return bl;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (HibernateException ignore) {}
            }
        }
    }

    AccessControl getAccessControlAnnotation(Class<?> objectType) {
        for (Class<?> daoInterface : this.daos.get(objectType).getClass().getInterfaces()) {
            AccessControl accessControl = daoInterface.getAnnotation(AccessControl.class);
            if (accessControl == null) continue;
            return accessControl;
        }
        return null;
    }
}

