/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.AccessControlDAO;
import org.iternine.jeppetto.dao.AccessControlException;
import org.iternine.jeppetto.dao.AccessType;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.FailedBatchException;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.OptimisticLockException;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.ProjectionType;
import org.iternine.jeppetto.dao.QueryModel;
import org.iternine.jeppetto.dao.QueryModelDAO;
import org.iternine.jeppetto.dao.Sort;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.TooManyItemsException;
import org.iternine.jeppetto.dao.hibernate.AccessControlContextOverride;
import org.iternine.jeppetto.dao.hibernate.AccessControlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateQueryModelDAO<T, ID extends Serializable>
implements QueryModelDAO<T, ID>,
AccessControlDAO<T, ID> {
    private static final StringType STRING_TYPE = new StringType();
    private Class<T> persistentClass;
    private SessionFactory sessionFactory;
    private AccessControlHelper accessControlHelper;
    private AccessControlContextProvider accessControlContextProvider;
    private String idField = "id";
    private static final Logger logger = LoggerFactory.getLogger(HibernateQueryModelDAO.class);

    protected HibernateQueryModelDAO(Class<T> persistentClass, Map<String, Object> daoProperties) {
        this(persistentClass, daoProperties, null);
    }

    protected HibernateQueryModelDAO(Class<T> persistentClass, Map<String, Object> daoProperties, AccessControlContextProvider accessControlContextProvider) {
        this.persistentClass = persistentClass;
        this.sessionFactory = (SessionFactory)daoProperties.get("sessionFactory");
        this.accessControlHelper = (AccessControlHelper)daoProperties.get("accessControlHelper");
        this.accessControlContextProvider = accessControlContextProvider;
        if (this.accessControlHelper != null) {
            this.accessControlHelper.registerDAO(persistentClass, this);
        }
    }

    public T findById(ID id) throws NoSuchItemException, JeppettoException {
        QueryModel queryModel = new QueryModel();
        queryModel.addCondition(this.buildIdCondition(id));
        if (this.accessControlContextProvider != null) {
            queryModel.setAccessControlContext(this.accessControlContextProvider.getCurrent());
        }
        return this.findUniqueUsingQueryModel(queryModel);
    }

    public Iterable<T> findByIds(ID ... ids) throws JeppettoException {
        QueryModel queryModel = new QueryModel();
        queryModel.addCondition(this.buildIdCondition(Arrays.asList(ids)));
        if (this.accessControlContextProvider != null) {
            queryModel.setAccessControlContext(this.accessControlContextProvider.getCurrent());
        }
        return this.findUsingQueryModel(queryModel);
    }

    public Iterable<T> findAll() throws JeppettoException {
        QueryModel queryModel = new QueryModel();
        if (this.accessControlContextProvider != null) {
            queryModel.setAccessControlContext(this.accessControlContextProvider.getCurrent());
        }
        return this.findUsingQueryModel(queryModel);
    }

    public void save(T entity) throws OptimisticLockException, JeppettoException {
        try {
            this.getCurrentSession().saveOrUpdate(entity);
            this.flush();
        }
        catch (org.hibernate.OptimisticLockException e) {
            throw new OptimisticLockException((Throwable)e);
        }
        catch (StaleObjectStateException e) {
            throw new OptimisticLockException((Throwable)e);
        }
        catch (HibernateException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public void delete(T entity) throws JeppettoException {
        try {
            this.getCurrentSession().delete(entity);
        }
        catch (HibernateException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public void deleteById(ID id) throws JeppettoException {
        try {
            this.getCurrentSession().delete(this.findById(id));
        }
        catch (NoSuchItemException noSuchItemException) {
        }
        catch (HibernateException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public void deleteByIds(ID ... ids) throws FailedBatchException, JeppettoException {
        LinkedHashMap<ID, Exception> failedDeletes = new LinkedHashMap<ID, Exception>();
        for (ID id : ids) {
            try {
                this.deleteById(id);
            }
            catch (Exception e) {
                failedDeletes.put(id, e);
            }
        }
        if (failedDeletes.size() > 0) {
            throw new FailedBatchException("Unable to delete all items", Collections.emptyList(), failedDeletes);
        }
    }

    public <U extends T> U getUpdateObject() {
        throw new RuntimeException("getUpdateObject not yet implemented");
    }

    public <U extends T> T updateById(U updateObject, ID id) throws JeppettoException {
        throw new RuntimeException("updateById not yet implemented");
    }

    public <U extends T> Iterable<T> updateByIds(U updateObject, ID ... ids) throws FailedBatchException, JeppettoException {
        throw new RuntimeException("updateByIds not yet implemented");
    }

    public void flush() throws JeppettoException {
        this.getCurrentSession().flush();
    }

    public T findUniqueUsingQueryModel(QueryModel queryModel) throws NoSuchItemException, TooManyItemsException, JeppettoException {
        Object result;
        try {
            result = this.accessControlContextProvider == null || this.accessControlHelper.annotationAllowsAccess(this.persistentClass, queryModel.getAccessControlContext(), AccessType.Read) ? this.buildCriteria(queryModel).uniqueResult() : this.createAccessControlledQuery(queryModel).uniqueResult();
        }
        catch (NonUniqueObjectException e) {
            throw new TooManyItemsException(e.getMessage());
        }
        catch (HibernateException e) {
            throw new JeppettoException((Throwable)e);
        }
        if (result == null) {
            throw new NoSuchItemException(this.persistentClass.getSimpleName(), queryModel.toString());
        }
        return (T)result;
    }

    public Iterable<T> findUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        try {
            if (this.accessControlContextProvider == null || this.accessControlHelper.annotationAllowsAccess(this.persistentClass, queryModel.getAccessControlContext(), AccessType.Read)) {
                Criteria criteria = this.buildCriteria(queryModel);
                if (queryModel.getSorts() != null) {
                    for (Sort sort : queryModel.getSorts()) {
                        criteria.addOrder(sort.getSortDirection() == SortDirection.Ascending ? Order.asc((String)sort.getField()) : Order.desc((String)sort.getField()));
                    }
                }
                if (queryModel.getMaxResults() > 0) {
                    criteria.setMaxResults(queryModel.getMaxResults());
                }
                if (queryModel.getFirstResult() > 0) {
                    criteria.setFirstResult(queryModel.getFirstResult());
                }
                return criteria.list();
            }
            return this.createAccessControlledQuery(queryModel).list();
        }
        catch (HibernateException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public Object projectUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        try {
            return this.buildCriteria(queryModel).uniqueResult();
        }
        catch (HibernateException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public void deleteUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        throw new RuntimeException("deleteUsingQueryModel not yet implemented");
    }

    public <U extends T> T updateUniqueUsingQueryModel(U updateObject, QueryModel queryModel) throws JeppettoException {
        throw new RuntimeException("updateUniqueUsingQueryModel not yet implemented");
    }

    public <U extends T> Iterable<T> updateUsingQueryModel(U updateObject, QueryModel queryModel) throws JeppettoException {
        throw new RuntimeException("updateUsingQueryModel not yet implemented");
    }

    public Condition buildCondition(String conditionField, ConditionType conditionType, Iterator argsIterator) {
        Condition condition = new Condition();
        condition.setField(conditionField);
        switch (conditionType) {
            case Between: {
                condition.setConstraint((Object)Restrictions.between((String)conditionField, argsIterator.next(), argsIterator.next()));
                break;
            }
            case Equal: {
                condition.setConstraint((Object)Restrictions.eq((String)conditionField, argsIterator.next()));
                break;
            }
            case GreaterThan: {
                condition.setConstraint((Object)Restrictions.gt((String)conditionField, argsIterator.next()));
                break;
            }
            case GreaterThanEqual: {
                condition.setConstraint((Object)Restrictions.ge((String)conditionField, argsIterator.next()));
                break;
            }
            case IsNotNull: {
                condition.setConstraint((Object)Restrictions.isNotNull((String)conditionField));
                break;
            }
            case IsNull: {
                condition.setConstraint((Object)Restrictions.isNull((String)conditionField));
                break;
            }
            case LessThan: {
                condition.setConstraint((Object)Restrictions.lt((String)conditionField, argsIterator.next()));
                break;
            }
            case LessThanEqual: {
                condition.setConstraint((Object)Restrictions.le((String)conditionField, argsIterator.next()));
                break;
            }
            case NotEqual: {
                condition.setConstraint((Object)Restrictions.ne((String)conditionField, argsIterator.next()));
                break;
            }
            case NotWithin: {
                condition.setConstraint((Object)Restrictions.not((Criterion)Restrictions.in((String)conditionField, (Collection)((Collection)argsIterator.next()))));
                break;
            }
            case Within: {
                condition.setConstraint((Object)Restrictions.in((String)conditionField, (Collection)((Collection)argsIterator.next())));
                break;
            }
            case BeginsWith: {
                condition.setConstraint((Object)Restrictions.like((String)conditionField, (Object)(argsIterator.next().toString() + '%')));
            }
        }
        return condition;
    }

    public Projection buildProjection(String projectionField, ProjectionType projectionType, Iterator argsIterator) {
        Projection projection = new Projection();
        projection.setField(projectionField);
        switch (projectionType) {
            case RowCount: {
                projection.setDetails((Object)Projections.rowCount());
                break;
            }
            case Count: {
                projection.setDetails((Object)Projections.count((String)projectionField));
                break;
            }
            case CountDistinct: {
                projection.setDetails((Object)Projections.countDistinct((String)projectionField));
                break;
            }
            case Maximum: {
                projection.setDetails((Object)Projections.max((String)projectionField));
                break;
            }
            case Minimum: {
                projection.setDetails((Object)Projections.min((String)projectionField));
                break;
            }
            case Average: {
                projection.setDetails((Object)Projections.avg((String)projectionField));
                break;
            }
            case Sum: {
                projection.setDetails((Object)Projections.sum((String)projectionField));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected projection type: " + projectionType);
            }
        }
        return projection;
    }

    public void save(T object, AccessControlContext accessControlContext) throws OptimisticLockException, AccessControlException, JeppettoException {
        this.ensureAccessControlEnabled();
        try {
            AccessControlContextOverride.set(accessControlContext);
            this.getCurrentSession().saveOrUpdate(object);
            this.flush();
        }
        catch (org.hibernate.OptimisticLockException e) {
            throw new OptimisticLockException((Throwable)e);
        }
        catch (HibernateException e) {
            throw new JeppettoException((Throwable)e);
        }
        finally {
            AccessControlContextOverride.clear();
        }
    }

    public void grantAccess(ID id, String accessId, AccessType accessType) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        this.grantAccess(id, accessId, accessType, this.accessControlContextProvider.getCurrent());
    }

    public void grantAccess(ID id, String accessId, AccessType accessType, AccessControlContext accessControlContext) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        if (accessType == AccessType.None) {
            this.revokeAccess(id, accessId, accessControlContext);
            return;
        }
        this.accessControlHelper.validateContextAllowsWrite(this.persistentClass, (Serializable)id, accessControlContext, true);
        this.accessControlHelper.createEntry(this.persistentClass, (Serializable)id, accessId, accessType);
    }

    public void revokeAccess(ID id, String accessId) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        this.revokeAccess(id, accessId, this.accessControlContextProvider.getCurrent());
    }

    public void revokeAccess(ID id, String accessId, AccessControlContext accessControlContext) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        this.accessControlHelper.validateContextAllowsWrite(this.persistentClass, (Serializable)id, accessControlContext, true);
        this.accessControlHelper.deleteEntry(this.persistentClass, (Serializable)id, accessId);
    }

    public Map<String, AccessType> getGrantedAccesses(ID id) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        return this.getGrantedAccesses(id, this.accessControlContextProvider.getCurrent());
    }

    public Map<String, AccessType> getGrantedAccesses(ID id, AccessControlContext accessControlContext) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        this.accessControlHelper.validateContextAllowsWrite(this.persistentClass, (Serializable)id, accessControlContext, true);
        return this.accessControlHelper.getEntries(this.persistentClass, (Serializable)id);
    }

    public AccessControlContextProvider getAccessControlContextProvider() {
        return this.accessControlContextProvider;
    }

    protected Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected Condition buildIdCondition(Object argument) {
        if (Collection.class.isAssignableFrom(argument.getClass())) {
            return new Condition(this.idField, (Object)Restrictions.in((String)this.idField, (Collection)((Collection)argument)));
        }
        return new Condition(this.idField, (Object)Restrictions.eq((String)this.idField, (Object)argument));
    }

    private Criteria buildCriteria(QueryModel queryModel) {
        Criteria criteria = this.getCurrentSession().createCriteria(this.persistentClass);
        if (queryModel.getConditions() != null) {
            for (Condition condition : queryModel.getConditions()) {
                criteria.add((Criterion)condition.getConstraint());
            }
        }
        for (Map.Entry entry : queryModel.getAssociationConditions().entrySet()) {
            Criteria associationCriteria = criteria.createCriteria((String)entry.getKey());
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            for (Condition condition : (List)entry.getValue()) {
                associationCriteria.add((Criterion)condition.getConstraint());
            }
        }
        if (queryModel.getProjection() != null) {
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((org.hibernate.criterion.Projection)queryModel.getProjection().getDetails());
            criteria.setProjection((org.hibernate.criterion.Projection)projectionList);
        }
        return criteria;
    }

    private Query createAccessControlledQuery(QueryModel queryModel) {
        Criteria criteria = this.getCurrentSession().createCriteria(this.persistentClass);
        for (String associationPath : queryModel.getAssociationConditions().keySet()) {
            criteria.createCriteria(associationPath);
        }
        CriteriaQueryTranslator criteriaQueryTranslator = new CriteriaQueryTranslator((SessionFactoryImplementor)this.sessionFactory, (CriteriaImpl)criteria, this.persistentClass.getName(), "this_");
        StringBuilder queryStringBuilder = new StringBuilder();
        this.buildSelectClause(queryStringBuilder, criteriaQueryTranslator, queryModel.getAssociationConditions().keySet());
        List<TypedValue> parameters = this.buildWhereClause(queryStringBuilder, queryModel, criteria, criteriaQueryTranslator);
        if ((queryModel.getAssociationConditions() == null || queryModel.getAssociationConditions().isEmpty()) && (queryModel.getSorts() == null || queryModel.getSorts().isEmpty())) {
            this.buildDefaultOrderClause(queryStringBuilder);
        } else {
            this.buildOrderClause(queryStringBuilder, queryModel, criteria, criteriaQueryTranslator);
        }
        Query query = this.getCurrentSession().createQuery(queryStringBuilder.toString());
        this.setParameters(parameters, query, queryModel.getAccessControlContext());
        return query;
    }

    private void buildSelectClause(StringBuilder queryStringBuilder, CriteriaQueryTranslator criteriaQueryTranslator, Set<String> associationPaths) {
        if (associationPaths.isEmpty()) {
            queryStringBuilder.append("select ");
        } else {
            queryStringBuilder.append("select distinct ");
        }
        queryStringBuilder.append(criteriaQueryTranslator.getRootSQLALias());
        queryStringBuilder.append(" from AccessControlEntry ace, ");
        queryStringBuilder.append(this.persistentClass.getSimpleName());
        queryStringBuilder.append(' ');
        queryStringBuilder.append(criteriaQueryTranslator.getRootSQLALias());
        for (String associationPath : associationPaths) {
            queryStringBuilder.append(" join ");
            queryStringBuilder.append(criteriaQueryTranslator.getRootSQLALias());
            queryStringBuilder.append('.');
            queryStringBuilder.append(associationPath);
            queryStringBuilder.append(" as ");
            queryStringBuilder.append(criteriaQueryTranslator.getSQLAlias(criteriaQueryTranslator.getCriteria(associationPath)));
        }
    }

    private List<TypedValue> buildWhereClause(StringBuilder queryStringBuilder, QueryModel queryModel, Criteria criteria, CriteriaQueryTranslator criteriaQueryTranslator) {
        ArrayList<TypedValue> parameters = new ArrayList<TypedValue>();
        queryStringBuilder.append(" where ");
        if (queryModel.getConditions() != null) {
            for (Condition condition : queryModel.getConditions()) {
                Criterion criterion = (Criterion)condition.getConstraint();
                queryStringBuilder.append(criterion.toSqlString(criteria, (CriteriaQuery)criteriaQueryTranslator));
                queryStringBuilder.append(" and ");
                parameters.addAll(Arrays.asList(criterion.getTypedValues(criteria, (CriteriaQuery)criteriaQueryTranslator)));
            }
        }
        if (queryModel.getAssociationConditions() != null) {
            for (Map.Entry entry : queryModel.getAssociationConditions().entrySet()) {
                CriteriaImpl.Subcriteria associationCriteria = (CriteriaImpl.Subcriteria)criteriaQueryTranslator.getCriteria((String)entry.getKey());
                for (Condition condition : (List)entry.getValue()) {
                    Criterion criterion = (Criterion)condition.getConstraint();
                    queryStringBuilder.append(criterion.toSqlString((Criteria)associationCriteria, (CriteriaQuery)criteriaQueryTranslator));
                    queryStringBuilder.append(" and ");
                    parameters.addAll(Arrays.asList(criterion.getTypedValues((Criteria)associationCriteria, (CriteriaQuery)criteriaQueryTranslator)));
                }
            }
        }
        queryStringBuilder.append(" ace.objectType = '");
        queryStringBuilder.append(this.persistentClass.getSimpleName());
        queryStringBuilder.append("' and ace.objectId = ");
        queryStringBuilder.append(criteriaQueryTranslator.getRootSQLALias());
        queryStringBuilder.append('.');
        queryStringBuilder.append(this.idField);
        queryStringBuilder.append(" and ace.accessibleBy = ? ");
        return parameters;
    }

    private void buildOrderClause(StringBuilder queryStringBuilder, QueryModel queryModel, Criteria criteria, CriteriaQueryTranslator criteriaQueryTranslator) {
        boolean firstOrderItem = true;
        if (queryModel.getSorts() != null) {
            for (Sort sort : queryModel.getSorts()) {
                if (firstOrderItem) {
                    queryStringBuilder.append(" order by ");
                } else {
                    queryStringBuilder.append(',');
                }
                Order order = sort.getSortDirection() == SortDirection.Ascending ? Order.asc((String)sort.getField()) : Order.desc((String)sort.getField());
                queryStringBuilder.append(order.toSqlString(criteria, (CriteriaQuery)criteriaQueryTranslator));
                firstOrderItem = false;
            }
        }
    }

    private void buildDefaultOrderClause(StringBuilder queryStringBuilder) {
        queryStringBuilder.append(" order by ace.id asc");
    }

    private void setParameters(List<TypedValue> parameters, Query query, AccessControlContext accessControlContext) {
        int position = 0;
        for (TypedValue parameter : parameters) {
            query.setParameter(position++, parameter.getValue(), parameter.getType());
        }
        query.setParameter(position, (Object)accessControlContext.getAccessId(), (Type)STRING_TYPE);
    }

    private void ensureAccessControlEnabled() {
        if (this.accessControlContextProvider == null) {
            throw new AccessControlException("Access Control is not enabled. No AccessControlContextProvider specified.");
        }
    }
}

