/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.jdbc.enhance;

import java.util.HashMap;
import java.util.Map;
import org.iternine.jeppetto.dao.jdbc.enhance.JDBCPersistable;
import org.iternine.jeppetto.enhance.Enhancer;
import org.iternine.jeppetto.enhance.NoOpEnhancer;
import org.iternine.jeppetto.enhance.VelocityEnhancer;

public class EnhancerHelper {
    private static Map<Class, Enhancer> jdbcPersistableEnhancers = new HashMap<Class, Enhancer>();

    public static <T> Enhancer<T> getJDBCPersistableEnhancer(Class<T> baseClass) {
        Object enhancer = jdbcPersistableEnhancers.get(baseClass);
        if (enhancer == null) {
            enhancer = JDBCPersistable.class.isAssignableFrom(baseClass) ? new NoOpEnhancer(baseClass) : new VelocityEnhancer<T>(baseClass){

                public boolean needsEnhancement(Object object) {
                    return object != null && !(object instanceof JDBCPersistable);
                }

                protected String getTemplateLocation() {
                    return "org/iternine/jeppetto/dao/jdbc/enhance/jdbcPersistable.vm";
                }
            };
            jdbcPersistableEnhancers.put(baseClass, (Enhancer)enhancer);
        }
        return enhancer;
    }
}

