/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.OptimisticLockException;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.ProjectionType;
import org.iternine.jeppetto.dao.QueryModel;
import org.iternine.jeppetto.dao.QueryModelDAO;
import org.iternine.jeppetto.dao.Sort;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.TooManyItemsException;
import org.iternine.jeppetto.dao.id.IdGenerator;
import org.iternine.jeppetto.dao.jdbc.JDBCCondition;
import org.iternine.jeppetto.dao.jdbc.JDBCConstraint;
import org.iternine.jeppetto.dao.jdbc.enhance.EnhancerHelper;
import org.iternine.jeppetto.dao.jdbc.enhance.JDBCPersistable;
import org.iternine.jeppetto.enhance.Enhancer;

public class JDBCQueryModelDAO<T, ID>
implements QueryModelDAO<T, ID> {
    private Class<T> entityClass;
    private Enhancer<T> enhancer;
    private DataSource dataSource;
    private IdGenerator<ID> idGenerator;
    private AccessControlContextProvider accessControlContextProvider;

    protected JDBCQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties) {
        this(entityClass, daoProperties, null);
    }

    protected JDBCQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties, AccessControlContextProvider accessControlContextProvider) {
        this.entityClass = entityClass;
        this.enhancer = EnhancerHelper.getJDBCPersistableEnhancer(entityClass);
        this.dataSource = (DataSource)daoProperties.get("dataSource");
        this.idGenerator = (IdGenerator)daoProperties.get("idGenerator");
        this.accessControlContextProvider = accessControlContextProvider;
    }

    public T findById(ID id) throws NoSuchItemException, JeppettoException {
        QueryModel queryModel = new QueryModel();
        queryModel.addCondition(this.buildCondition("id", ConditionType.Equal, Collections.singletonList(id).iterator()));
        return this.findUniqueUsingQueryModel(queryModel);
    }

    public Iterable<T> findAll() throws JeppettoException {
        return this.findUsingQueryModel(new QueryModel());
    }

    public void save(T entity) throws OptimisticLockException, JeppettoException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ((JDBCPersistable)this.enhancer.enhance(entity)).save(connection, this.idGenerator);
        }
        catch (SQLException e) {
            throw new JeppettoException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public void delete(T entity) throws JeppettoException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ((JDBCPersistable)this.enhancer.enhance(entity)).delete(connection);
        }
        catch (SQLException e) {
            throw new JeppettoException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public void deleteById(ID id) throws JeppettoException {
        Object entity = this.enhancer.newInstance();
        try {
            entity.getClass().getMethod("setId", new Class[0]).invoke(entity, id);
        }
        catch (Exception e) {
            throw new JeppettoException((Throwable)e);
        }
        this.delete(entity);
    }

    public void flush() throws JeppettoException {
    }

    public T findUniqueUsingQueryModel(QueryModel queryModel) throws NoSuchItemException, TooManyItemsException, JeppettoException {
        Object object;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = this.buildPreparedStatement(connection, queryModel);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new NoSuchItemException(this.entityClass.getSimpleName(), this.buildSelectString(queryModel));
            }
            Object t = this.enhancer.newInstance();
            ((JDBCPersistable)t).populateObject(resultSet);
            if (resultSet.next()) {
                throw new TooManyItemsException(this.entityClass.getSimpleName(), this.buildSelectString(queryModel));
            }
            object = t;
        }
        catch (SQLException e) {
            throw new JeppettoException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException ignore) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException ignore) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignore) {}
            }
        }
        return (T)object;
    }

    public Iterable<T> findUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = this.buildPreparedStatement(connection, queryModel);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Object> result = new ArrayList<Object>();
            while (resultSet.next()) {
                Object t = this.enhancer.newInstance();
                ((JDBCPersistable)t).populateObject(resultSet);
                result.add(t);
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new JeppettoException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException ignore) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException ignore) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public Object projectUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        throw new RuntimeException("projectUsingQueryModel not yet implemented");
    }

    public void deleteUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        throw new RuntimeException("deleteUsingQueryModel not yet implemented");
    }

    public Condition buildCondition(String conditionField, ConditionType conditionType, Iterator argsIterator) {
        JDBCCondition jdbcCondition = JDBCCondition.valueOf(conditionType.name());
        return new Condition(conditionField, jdbcCondition.buildConstraint(argsIterator));
    }

    public Projection buildProjection(String projectionField, ProjectionType projectionType, Iterator argsIterator) {
        return null;
    }

    private PreparedStatement buildPreparedStatement(Connection connection, QueryModel queryModel) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(this.buildSelectString(queryModel));
        int parameterLocation = 1;
        for (Condition condition : queryModel.getConditions()) {
            JDBCConstraint jdbcConstraint = (JDBCConstraint)condition.getConstraint();
            if (jdbcConstraint.getParameter1() != null) {
                preparedStatement.setObject(parameterLocation++, jdbcConstraint.getParameter1());
            }
            if (jdbcConstraint.getParameter2() == null) continue;
            preparedStatement.setObject(parameterLocation++, jdbcConstraint.getParameter2());
        }
        return preparedStatement;
    }

    private String buildSelectString(QueryModel queryModel) {
        boolean first;
        StringBuilder selectClause = new StringBuilder("SELECT * FROM " + this.entityClass.getSimpleName());
        if (queryModel.getConditions() != null && !queryModel.getConditions().isEmpty()) {
            selectClause.append(" WHERE ");
            first = true;
            for (Condition condition : queryModel.getConditions()) {
                if (!first) {
                    selectClause.append(" AND ");
                }
                selectClause.append(condition.getField());
                selectClause.append(((JDBCConstraint)condition.getConstraint()).getConstraintString());
                first = false;
            }
        }
        if (queryModel.getSorts() != null && !queryModel.getSorts().isEmpty()) {
            selectClause.append(" ORDER BY ");
            first = true;
            for (Sort sort : queryModel.getSorts()) {
                if (!first) {
                    selectClause.append(" AND ");
                }
                selectClause.append(sort.getField());
                if (sort.getSortDirection() == SortDirection.Descending) {
                    selectClause.append(" DESC ");
                }
                first = false;
            }
        }
        if (queryModel.getMaxResults() > 0) {
            selectClause.append(" LIMIT ");
            selectClause.append(queryModel.getMaxResults());
        }
        if (queryModel.getFirstResult() > 0) {
            selectClause.append(" OFFSET ");
            selectClause.append(queryModel.getFirstResult());
        }
        return selectClause.toString();
    }
}

