/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.iternine.jeppetto.dao.jdbc.JDBCConstraint;

public enum JDBCCondition {
    NotEqual(" <> ? "),
    GreaterThanEqual(" >= ? "),
    LessThanEqual(" <= ? "),
    Equal(" = ? "),
    GreaterThan(" > ? "),
    LessThan(" < ? "),
    NotWithin(" NOT IN "),
    Within(" IN "),
    Between(" BETWEEN ? AND ? "),
    IsNull(" IS NULL "),
    IsNotNull(" IS NOT NULL "),
    BeginsWith(" LIKE ");

    private String operator;

    private JDBCCondition(String operator) {
        this.operator = operator;
    }

    public Object buildConstraint(Iterator argsIterator) {
        JDBCConstraint jdbcConstraint = new JDBCConstraint();
        jdbcConstraint.setConstraintString(this.operator);
        switch (this) {
            case Equal: 
            case NotEqual: 
            case GreaterThan: 
            case GreaterThanEqual: 
            case LessThan: 
            case LessThanEqual: 
            case Within: 
            case NotWithin: {
                jdbcConstraint.setParameter1(this.translateEnumsIfNecessary(argsIterator.next()));
                break;
            }
            case Between: {
                jdbcConstraint.setParameter1(this.translateEnumsIfNecessary(argsIterator.next()));
                jdbcConstraint.setParameter2(this.translateEnumsIfNecessary(argsIterator.next()));
                break;
            }
            case IsNull: 
            case IsNotNull: {
                break;
            }
            case BeginsWith: {
                jdbcConstraint.setParameter1(argsIterator.next().toString() + '%');
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enumeration: " + (Object)((Object)this));
            }
        }
        return jdbcConstraint;
    }

    private Object translateEnumsIfNecessary(Object argument) {
        if (argument == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(argument.getClass())) {
            return ((Enum)argument).name();
        }
        if (List.class.isAssignableFrom(argument.getClass()) && ((List)argument).size() > 0 && Enum.class.isAssignableFrom(((List)argument).get(0).getClass())) {
            ArrayList<String> newList = new ArrayList<String>();
            for (Object listMember : (List)argument) {
                newList.add(((Enum)listMember).name());
            }
            return newList;
        }
        return argument;
    }
}

