/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.AccessControllable;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.ProjectionType;
import org.iternine.jeppetto.dao.QueryModel;
import org.iternine.jeppetto.dao.QueryModelDAO;
import org.iternine.jeppetto.dao.Sort;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.annotation.AccessControl;
import org.iternine.jeppetto.dao.annotation.AccessControlRule;
import org.iternine.jeppetto.dao.annotation.AccessControlType;
import org.iternine.jeppetto.dao.mongodb.BasicDBObjectCommand;
import org.iternine.jeppetto.dao.mongodb.MongoDBCommand;
import org.iternine.jeppetto.dao.mongodb.MongoDBOperator;
import org.iternine.jeppetto.dao.mongodb.MongoDBSession;
import org.iternine.jeppetto.dao.mongodb.QueryLoggingCommand;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;
import org.iternine.jeppetto.dao.mongodb.enhance.EnhancerHelper;
import org.iternine.jeppetto.dao.mongodb.enhance.MongoDBDecoder;
import org.iternine.jeppetto.dao.mongodb.projections.ProjectionCommands;
import org.iternine.jeppetto.enhance.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBQueryModelDAO<T, ID>
implements QueryModelDAO<T, ID>,
AccessControllable<ID> {
    private static final String ID_FIELD = "_id";
    private static final String OPTIMISTIC_LOCK_VERSION_FIELD = "__olv";
    private static final String ACCESS_CONTROL_LIST_FIELD = "__acl";
    private DBCollection dbCollection;
    private Enhancer<T> enhancer;
    private AccessControlContextProvider accessControlContextProvider;
    private Map<String, Set<String>> uniqueIndexes;
    private boolean optimisticLockEnabled;
    private List<String> shardKeys;
    private boolean saveNulls;
    private WriteConcern defaultWriteConcern;
    private Logger queryLogger;

    protected MongoDBQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties) {
        this(entityClass, daoProperties, null);
    }

    protected MongoDBQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties, AccessControlContextProvider accessControlContextProvider) {
        this.dbCollection = ((DB)daoProperties.get("db")).getCollection(entityClass.getSimpleName());
        this.enhancer = EnhancerHelper.getDirtyableDBObjectEnhancer(entityClass);
        this.dbCollection.setObjectClass(this.enhancer.getEnhancedClass());
        this.dbCollection.setDBDecoderFactory(new DBDecoderFactory(){

            public DBDecoder create() {
                return new MongoDBDecoder();
            }
        });
        this.accessControlContextProvider = accessControlContextProvider;
        this.uniqueIndexes = this.ensureIndexes((List)daoProperties.get("uniqueIndexes"), true);
        this.ensureIndexes((List)daoProperties.get("nonUniqueIndexes"), false);
        this.optimisticLockEnabled = Boolean.parseBoolean((String)daoProperties.get("optimisticLockEnabled"));
        this.shardKeys = this.extractShardKeys((String)daoProperties.get("shardKeyPattern"));
        this.saveNulls = Boolean.parseBoolean((String)daoProperties.get("saveNulls"));
        this.defaultWriteConcern = daoProperties.containsKey("writeConcern") ? WriteConcern.valueOf((String)((String)daoProperties.get("writeConcern"))) : WriteConcern.SAFE;
        if (Boolean.parseBoolean((String)daoProperties.get("showQueries"))) {
            this.queryLogger = LoggerFactory.getLogger(this.getClass());
        }
    }

    public T findById(ID id) throws NoSuchItemException {
        try {
            QueryModel queryModel = new QueryModel();
            queryModel.addCondition(this.buildIdCondition(id));
            if (this.accessControlContextProvider != null) {
                queryModel.setAccessControlContext(this.accessControlContextProvider.getCurrent());
            }
            return this.findUniqueUsingQueryModel(queryModel);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchItemException(this.getCollectionClass().getSimpleName(), id.toString());
        }
    }

    public final Iterable<T> findAll() {
        QueryModel queryModel = new QueryModel();
        if (this.accessControlContextProvider != null) {
            queryModel.setAccessControlContext(this.accessControlContextProvider.getCurrent());
        }
        return this.findUsingQueryModel(queryModel);
    }

    public final void save(T entity) {
        Object enhancedEntity = this.enhancer.enhance(entity);
        DirtyableDBObject dbo = (DirtyableDBObject)enhancedEntity;
        if (!dbo.isPersisted()) {
            if (dbo.get(ID_FIELD) == null) {
                dbo.put(ID_FIELD, new ObjectId());
            }
            if (this.accessControlContextProvider != null) {
                if (this.roleAllowsAccess(this.accessControlContextProvider.getCurrent().getRole()) || this.accessControlContextProvider.getCurrent().getAccessId() == null) {
                    dbo.put(ACCESS_CONTROL_LIST_FIELD, Collections.emptyList());
                } else {
                    dbo.put(ACCESS_CONTROL_LIST_FIELD, Collections.singletonList(this.accessControlContextProvider.getCurrent().getAccessId()));
                }
            }
        }
        DBObject identifyingQuery = this.buildIdentifyingQuery(dbo);
        if (MongoDBSession.isActive()) {
            MongoDBSession.trackForSave(this, identifyingQuery, enhancedEntity, this.createIdentifyingQueries(dbo));
        } else {
            this.trueSave(identifyingQuery, dbo);
        }
    }

    public final void delete(T entity) {
        DBObject dbo = (DBObject)this.enhancer.enhance(entity);
        DBObject identifyingQuery = this.buildIdentifyingQuery(dbo);
        for (String shardKey : this.shardKeys) {
            identifyingQuery.put(shardKey, dbo.get(shardKey));
        }
        this.deleteByIdentifyingQuery(identifyingQuery);
    }

    public final void deleteById(ID id) {
        this.deleteByIdentifyingQuery(this.buildIdentifyingQuery(id));
    }

    public final void flush() {
        if (MongoDBSession.isActive()) {
            MongoDBSession.flush(this);
        }
    }

    public T findUniqueUsingQueryModel(QueryModel queryModel) throws NoSuchItemException {
        Object cached;
        MongoDBCommand command = this.buildCommand(queryModel);
        if (MongoDBSession.isActive() && (cached = MongoDBSession.getObjectFromCache(this.dbCollection.getName(), command.getQuery())) != null) {
            DBObject identifyingQuery = this.buildIdentifyingQuery((DBObject)cached);
            MongoDBSession.trackForSave(this, identifyingQuery, cached, this.createIdentifyingQueries((DBObject)cached));
            return (T)cached;
        }
        Object result = command.singleResult(this.dbCollection);
        if (MongoDBSession.isActive()) {
            DBObject identifyingQuery = this.buildIdentifyingQuery((DBObject)result);
            MongoDBSession.trackForSave(this, identifyingQuery, result, this.createIdentifyingQueries((DBObject)result));
        }
        return (T)result;
    }

    public Iterable<T> findUsingQueryModel(QueryModel queryModel) {
        MongoDBCommand command = this.buildCommand(queryModel);
        DBCursor dbCursor = command.cursor(this.dbCollection);
        if (queryModel.getSorts() != null) {
            dbCursor.sort(this.processSorts(queryModel.getSorts()));
        }
        if (queryModel.getFirstResult() > 0) {
            dbCursor = dbCursor.skip(queryModel.getFirstResult());
        }
        if (queryModel.getMaxResults() > 0) {
            dbCursor = dbCursor.limit(queryModel.getMaxResults());
        }
        final DBCursor finalDbCursor = dbCursor;
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return finalDbCursor.hasNext();
                    }

                    @Override
                    public T next() {
                        DBObject result = finalDbCursor.next();
                        ((DirtyableDBObject)result).markPersisted();
                        if (MongoDBSession.isActive()) {
                            MongoDBSession.trackForSave(MongoDBQueryModelDAO.this, MongoDBQueryModelDAO.this.buildIdentifyingQuery(result), result, MongoDBQueryModelDAO.this.createIdentifyingQueries(result));
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        finalDbCursor.remove();
                    }
                };
            }
        };
    }

    public Object projectUsingQueryModel(QueryModel queryModel) {
        try {
            return this.buildCommand(queryModel).singleResult(this.dbCollection);
        }
        catch (NoSuchItemException e) {
            return null;
        }
    }

    public Condition buildCondition(String conditionField, ConditionType conditionType, Iterator argsIterator) {
        if (conditionField.equals("id")) {
            return this.buildIdCondition(argsIterator.next());
        }
        return new Condition(conditionField, MongoDBOperator.valueOf(conditionType.name()).buildConstraint(argsIterator));
    }

    public Projection buildProjection(String projectionField, ProjectionType projectionType, Iterator argsIterator) {
        return new Projection(projectionField, (Object)projectionType);
    }

    public void grantAccess(ID id, String accessId) {
        DBObject dbObject;
        try {
            dbObject = (DBObject)this.findById(id);
        }
        catch (NoSuchItemException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> accessControlList = (ArrayList<String>)dbObject.get(ACCESS_CONTROL_LIST_FIELD);
        if (accessControlList == null) {
            accessControlList = new ArrayList<String>();
        }
        accessControlList.add(accessId);
        dbObject.put(ACCESS_CONTROL_LIST_FIELD, accessControlList);
        this.save(dbObject);
    }

    public void revokeAccess(ID id, String accessId) {
        DBObject dbObject;
        try {
            dbObject = (DBObject)this.findById(id);
        }
        catch (NoSuchItemException e) {
            throw new RuntimeException(e);
        }
        List accessControlList = (List)dbObject.get(ACCESS_CONTROL_LIST_FIELD);
        if (accessControlList == null) {
            return;
        }
        accessControlList.remove(accessId);
        dbObject.put(ACCESS_CONTROL_LIST_FIELD, (Object)accessControlList);
        this.save(dbObject);
    }

    public List<String> getAccessIds(ID id) {
        DBObject dbObject;
        try {
            dbObject = (DBObject)this.findById(id);
        }
        catch (NoSuchItemException e) {
            throw new RuntimeException(e);
        }
        return (List)dbObject.get(ACCESS_CONTROL_LIST_FIELD);
    }

    public AccessControlContextProvider getAccessControlContextProvider() {
        return this.accessControlContextProvider;
    }

    protected DBObject augmentObjectCacheKey(DBObject key) {
        return key;
    }

    protected DBObject[] createIdentifyingQueries(DBObject dbObject) {
        int uniqueIndexCount = this.uniqueIndexes.size() + 1;
        ArrayList<DBObject> queries = new ArrayList<DBObject>(uniqueIndexCount);
        queries.add(this.buildIdentifyingQuery(dbObject));
        for (Set<String> indexFields : this.uniqueIndexes.values()) {
            BasicDBObject query = new BasicDBObject();
            for (String indexField : indexFields) {
                query.put(indexField, this.getFieldValueFrom(dbObject, indexField));
            }
            queries.add(this.augmentObjectCacheKey((DBObject)query));
        }
        return queries.toArray(new DBObject[uniqueIndexCount]);
    }

    protected final DBObject buildIdentifyingQuery(DBObject dbObject) {
        return this.buildIdentifyingQuery(dbObject.get(ID_FIELD));
    }

    protected final DBObject buildIdentifyingQuery(ID id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        if (id instanceof String && ObjectId.isValid((String)((String)id))) {
            return new BasicDBObject(ID_FIELD, (Object)new ObjectId((String)id));
        }
        return new BasicDBObject(ID_FIELD, id);
    }

    protected final void deleteByIdentifyingQuery(DBObject identifyingQuery) {
        if (MongoDBSession.isActive()) {
            MongoDBSession.trackForDelete(this, identifyingQuery);
        } else {
            this.trueRemove(identifyingQuery);
        }
    }

    protected final void trueSave(DBObject identifyingQuery, DirtyableDBObject dbo) {
        if (this.optimisticLockEnabled) {
            Integer optimisticLockVersion = (Integer)dbo.get(OPTIMISTIC_LOCK_VERSION_FIELD);
            if (optimisticLockVersion == null) {
                dbo.put(OPTIMISTIC_LOCK_VERSION_FIELD, 1);
            } else {
                identifyingQuery.put(OPTIMISTIC_LOCK_VERSION_FIELD, (Object)optimisticLockVersion);
                dbo.put(OPTIMISTIC_LOCK_VERSION_FIELD, optimisticLockVersion + 1);
            }
        }
        for (String shardKey : this.shardKeys) {
            identifyingQuery.put(shardKey, dbo.get(shardKey));
        }
        DBObject optimalDbo = this.determineOptimalDBObject(dbo);
        if (this.queryLogger != null) {
            this.queryLogger.debug("Saving {} identified by {} with document {}", new Object[]{this.getCollectionClass().getSimpleName(), identifyingQuery.toMap(), optimalDbo.toMap()});
        }
        this.dbCollection.update(identifyingQuery, optimalDbo, true, false, this.getWriteConcern());
        dbo.markPersisted();
    }

    protected final void trueRemove(DBObject identifyingQuery) {
        if (this.optimisticLockEnabled) {
            // empty if block
        }
        if (this.queryLogger != null) {
            this.queryLogger.debug("Removing {}s matching {}", new Object[]{this.getCollectionClass().getSimpleName(), identifyingQuery.toMap()});
        }
        this.dbCollection.remove(identifyingQuery, this.getWriteConcern());
    }

    protected final DBCollection getDbCollection() {
        return this.dbCollection;
    }

    protected final Class<?> getCollectionClass() {
        return this.enhancer.getBaseClass();
    }

    private DBObject processSorts(List<Sort> sorts) {
        BasicDBObject orderBy = new BasicDBObject();
        for (Sort sort : sorts) {
            orderBy.put(sort.getField(), (Object)(sort.getSortDirection() == SortDirection.Ascending ? 1 : -1));
        }
        return orderBy;
    }

    private Condition buildIdCondition(Object argument) {
        if (argument instanceof String && ObjectId.isValid((String)((String)argument))) {
            return new Condition(ID_FIELD, (Object)new ObjectId((String)argument));
        }
        if (Iterable.class.isAssignableFrom(argument.getClass())) {
            ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
            for (Object argumentItem : (Iterable)argument) {
                if (argumentItem == null) {
                    objectIds.add(null);
                    continue;
                }
                if (argumentItem instanceof ObjectId) {
                    objectIds.add((ObjectId)argumentItem);
                    continue;
                }
                if (argumentItem instanceof String) {
                    objectIds.add(new ObjectId((String)argumentItem));
                    continue;
                }
                throw new IllegalArgumentException("Don't know how to handle class for 'id' mapping: " + argumentItem.getClass());
            }
            return new Condition(ID_FIELD, (Object)new BasicDBObject("$in", objectIds));
        }
        return new Condition(ID_FIELD, argument);
    }

    private Object getFieldValueFrom(DBObject dbo, String field) {
        String subField;
        if (!field.contains(".")) {
            return dbo.get(field);
        }
        Object value = dbo;
        String[] arr$ = field.split(".");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (value = value.get(subField = arr$[i$])) != null; ++i$) {
        }
        return value;
    }

    private MongoDBCommand buildCommand(QueryModel queryModel) {
        BasicDBObject query = this.buildQueryObject(queryModel);
        MongoDBCommand command = queryModel.getProjection() == null ? new BasicDBObjectCommand(query) : ProjectionCommands.forProjection(queryModel.getProjection(), (DBObject)query);
        if (this.queryLogger != null) {
            return QueryLoggingCommand.wrap(command, this.queryLogger);
        }
        return command;
    }

    private Map<String, Set<String>> ensureIndexes(List<String> uniqueIndexes, boolean unique) {
        if (uniqueIndexes == null || uniqueIndexes.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String uniqueIndex : uniqueIndexes) {
            String[] indexFields;
            BasicDBObject index = new BasicDBObject();
            for (String indexField : indexFields = uniqueIndex.split(",")) {
                if ((indexField = indexField.trim()).startsWith("+")) {
                    index.put(indexField.substring(1), (Object)1);
                    continue;
                }
                if (indexField.startsWith("-")) {
                    index.put(indexField.substring(1), (Object)-1);
                    continue;
                }
                index.put(indexField, (Object)1);
            }
            result.put(uniqueIndex, index.keySet());
            if (this.queryLogger != null) {
                this.queryLogger.debug("Ensuring index {} on {}", new Object[]{index.toMap(), this.getCollectionClass().getSimpleName()});
            }
            this.dbCollection.ensureIndex((DBObject)index, this.createIndexName(uniqueIndex), unique);
        }
        return result;
    }

    private String createIndexName(String indexSpec) {
        return indexSpec.replace(',', '-');
    }

    private List<String> extractShardKeys(String shardKeyPattern) {
        if (shardKeyPattern == null) {
            return Collections.emptyList();
        }
        String[] shardKeyParts = shardKeyPattern.split(",");
        ArrayList<String> shardKeys = new ArrayList<String>(shardKeyParts.length);
        for (String shardKey : shardKeyParts) {
            if ((shardKey = shardKey.trim()).equals("id") || shardKey.equals(ID_FIELD)) continue;
            shardKeys.add(shardKey);
        }
        return shardKeys;
    }

    private BasicDBObject buildQueryObject(QueryModel queryModel) {
        BasicDBObject query = new BasicDBObject();
        ArrayList<Condition> allCriteria = new ArrayList<Condition>();
        if (queryModel.getConditions() != null) {
            allCriteria.addAll(queryModel.getConditions());
        }
        for (Map.Entry associationConditions : queryModel.getAssociationConditions().entrySet()) {
            for (Condition condition : (List)associationConditions.getValue()) {
                condition.setField((String)associationConditions.getKey() + "." + condition.getField());
                allCriteria.add(condition);
            }
        }
        for (Condition condition : allCriteria) {
            Object rawConstraint = condition.getConstraint();
            Object constraint = rawConstraint == null ? null : DBObjectUtil.toDBObject(rawConstraint.getClass(), rawConstraint, new Type[0]);
            query.put(condition.getField(), constraint);
        }
        if (this.accessControlContextProvider != null && !this.roleAllowsAccess(queryModel.getAccessControlContext().getRole())) {
            query.put(ACCESS_CONTROL_LIST_FIELD, (Object)queryModel.getAccessControlContext().getAccessId());
        }
        return query;
    }

    private DBObject determineOptimalDBObject(DBObject dbo) {
        return dbo;
    }

    private WriteConcern getWriteConcern() {
        return this.defaultWriteConcern;
    }

    private boolean roleAllowsAccess(String role) {
        if (role == null || role.isEmpty()) {
            return false;
        }
        AccessControl accessControl = this.getAccessControlAnnotation();
        if (accessControl == null) {
            return false;
        }
        for (AccessControlRule accessControlRule : accessControl.rules()) {
            if (accessControlRule.type() != AccessControlType.Role || !accessControlRule.value().equals(role)) continue;
            return true;
        }
        return false;
    }

    private AccessControl getAccessControlAnnotation() {
        for (Class<?> collectionClass = this.getCollectionClass(); collectionClass != null; collectionClass = collectionClass.getSuperclass()) {
            AccessControl accessControl = collectionClass.getAnnotation(AccessControl.class);
            if (accessControl == null) continue;
            return accessControl;
        }
        return null;
    }
}

