/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;

public class DirtyableDBObjectMap
implements Map,
DirtyableDBObject {
    private boolean dirty;
    private Map delegate;

    public DirtyableDBObjectMap() {
        this.delegate = new HashMap();
    }

    public DirtyableDBObjectMap(Map delegate) {
        this.delegate = delegate;
    }

    public Object put(Object key, Object value) {
        this.dirty = true;
        return this.delegate.put(key, value);
    }

    public Object remove(Object key) {
        Object result = this.delegate.remove(key);
        if (result != null) {
            this.dirty = true;
        }
        return result;
    }

    public void putAll(Map m) {
        if (!m.isEmpty()) {
            this.dirty = true;
        }
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.dirty = true;
        }
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.delegate.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.delegate.containsValue(o);
    }

    public Object get(Object o) {
        return this.delegate.get(o);
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markPersisted() {
        this.dirty = false;
    }

    @Override
    public boolean isPersisted() {
        throw new RuntimeException("Can't determine persisted state.");
    }

    public void markAsPartialObject() {
        throw new RuntimeException("Can't mark DirtyableMap as partial");
    }

    public boolean isPartialObject() {
        return false;
    }

    public Object put(String key, Object value) {
        this.dirty = true;
        return this.delegate.put(key, value);
    }

    public void putAll(BSONObject bsonObject) {
        Set keys = bsonObject.keySet();
        if (keys.isEmpty()) {
            return;
        }
        this.dirty = true;
        for (String key : keys) {
            this.delegate.put(key, bsonObject.get(key));
        }
    }

    public Object get(String key) {
        return this.delegate.get(key);
    }

    public Map toMap() {
        return this;
    }

    public Object removeField(String key) {
        return this.remove(key);
    }

    public boolean containsKey(String key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsField(String field) {
        return this.delegate.containsKey(field);
    }
}

