/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import java.util.HashMap;
import java.util.Map;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;
import org.iternine.jeppetto.enhance.Enhancer;
import org.iternine.jeppetto.enhance.NoOpEnhancer;
import org.iternine.jeppetto.enhance.VelocityEnhancer;

public class EnhancerHelper {
    private static Map<Class, Enhancer> dirtyableDBObjectEnhancers = new HashMap<Class, Enhancer>();

    public static <T> Enhancer<T> getDirtyableDBObjectEnhancer(Class<T> baseClass) {
        Object enhancer = dirtyableDBObjectEnhancers.get(baseClass);
        if (enhancer == null) {
            enhancer = DirtyableDBObject.class.isAssignableFrom(baseClass) ? new NoOpEnhancer(baseClass) : new VelocityEnhancer<T>(baseClass){

                public boolean needsEnhancement(Object object) {
                    return object != null && !(object instanceof DirtyableDBObject);
                }

                protected String getTemplateLocation() {
                    return "org/iternine/jeppetto/dao/mongodb/enhance/dirtyableDBObject.vm";
                }
            };
            dirtyableDBObjectEnhancers.put(baseClass, (Enhancer)enhancer);
        }
        return enhancer;
    }
}

