/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.TooManyItemsException;
import org.iternine.jeppetto.dao.mongodb.MongoDBCommand;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;

public class BasicDBObjectCommand
extends MongoDBCommand {
    private BasicDBObject query;

    public BasicDBObjectCommand(BasicDBObject query) {
        this.query = query;
    }

    @Override
    public DBCursor cursor(DBCollection dbCollection) {
        return dbCollection.find((DBObject)this.query);
    }

    @Override
    public Object singleResult(DBCollection dbCollection) throws NoSuchItemException, TooManyItemsException {
        DBCursor cursor = this.cursor(dbCollection);
        cursor.limit(2);
        if (!cursor.hasNext()) {
            throw new NoSuchItemException(dbCollection.getName(), this.query.toString());
        }
        DBObject result = cursor.next();
        if (cursor.hasNext()) {
            throw new TooManyItemsException(dbCollection.getName(), this.query.toString());
        }
        ((DirtyableDBObject)result).markPersisted();
        return result;
    }

    @Override
    public DBObject getQuery() {
        return this.query;
    }

    @Override
    public String toString() {
        return super.toString() + ' ' + this.query;
    }
}

