/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.DBRefBase;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectList;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectMap;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectSet;
import org.iternine.jeppetto.dao.mongodb.enhance.EnhancerHelper;
import org.iternine.jeppetto.enhance.Enhancer;

public class DBObjectUtil {
    private static final Set<Class<?>> NO_CONVERSION_CLASSES = new HashSet();

    public static boolean objectIsMutable(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean needsNoConversion(Class clazz) {
        return NO_CONVERSION_CLASSES.contains(clazz);
    }

    public static Object fromObject(Class<?> type, Object o, Class<?> ... typeParameters) {
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            if (List.class.isAssignableFrom(type)) {
                return DBObjectUtil.fromList(o, typeParameters);
            }
            if (Map.class.isAssignableFrom(type)) {
                return DBObjectUtil.fromMap(o, typeParameters);
            }
            if (Set.class.isAssignableFrom(type)) {
                return DBObjectUtil.fromSet(o, typeParameters);
            }
            if (Iterable.class.isAssignableFrom(type)) {
                return DBObjectUtil.fromList(o, typeParameters);
            }
            return type.cast(o);
        }
        if (Iterable.class.isAssignableFrom(o.getClass()) && Set.class.isAssignableFrom(type)) {
            return DBObjectUtil.fromSet(o, typeParameters);
        }
        if (o instanceof DBObject) {
            DBObject copy = (DBObject)EnhancerHelper.getDirtyableDBObjectEnhancer(type).newInstance();
            copy.putAll((BSONObject)((DBObject)o));
            return copy;
        }
        if (Enum.class.isAssignableFrom(type) && String.class.isAssignableFrom(o.getClass())) {
            return Enum.valueOf(type, (String)o);
        }
        if (BigDecimal.class == type && Number.class.isAssignableFrom(o.getClass())) {
            return BigDecimal.valueOf(((Number)o).doubleValue());
        }
        if (BigInteger.class == type && Number.class.isAssignableFrom(o.getClass())) {
            return BigInteger.valueOf(((Number)o).longValue());
        }
        throw new RuntimeException("Not sure how to convert a " + o + " to a " + type.getSimpleName());
    }

    public static Object toDBObject(Class<?> cls, Object obj, Type ... optionalValueTypes) {
        return DBObjectUtil.prepareObjectForMongo(new TypeDefinition(cls, optionalValueTypes), obj);
    }

    public static Object toDBObject(Class<?> cls, boolean obj, Type ... optionalValueTypes) {
        return obj;
    }

    public static Object toDBObject(Class<?> cls, byte obj, Type ... optionalValueTypes) {
        return obj;
    }

    public static Object toDBObject(Class<?> cls, short obj, Type ... optionalValueTypes) {
        return obj;
    }

    public static Object toDBObject(Class<?> cls, int obj, Type ... optionalValueTypes) {
        return obj;
    }

    public static Object toDBObject(Class<?> cls, long obj, Type ... optionalValueTypes) {
        return obj;
    }

    public static Object toDBObject(Class<?> cls, float obj, Type ... optionalValueTypes) {
        return Float.valueOf(obj);
    }

    public static Object toDBObject(Class<?> cls, double obj, Type ... optionalValueTypes) {
        return obj;
    }

    private static Object prepareObjectForMongo(TypeDefinition typeDef, Object object) {
        if (object == null) {
            return null;
        }
        if (DBObjectUtil.needsNoConversion(typeDef.getClazz(), object) || Map.class.isInstance(object) || Iterable.class.isInstance(object)) {
            if (DBObjectUtil.mayHaveMembersThatNeedConversion(object)) {
                return DBObjectUtil.prepareObjectMembersForMongo(typeDef, object);
            }
            return object;
        }
        if (Enum.class.isInstance(object)) {
            return ((Enum)object).name();
        }
        Enhancer<?> enhancer = EnhancerHelper.getDirtyableDBObjectEnhancer(object.getClass());
        return enhancer.enhance(object);
    }

    private static boolean mayHaveMembersThatNeedConversion(Object obj) {
        return DBObject.class.isInstance(obj) || Map.class.isInstance(obj) || Iterable.class.isInstance(obj);
    }

    private static Object prepareObjectMembersForMongo(TypeDefinition typeDef, Object object) {
        Class<?> cls = typeDef.getClazz();
        Type[] optionalValueTypes = typeDef.getTypeParameters();
        if (DBObject.class.isAssignableFrom(cls)) {
            BasicDBObject dbo = new BasicDBObject();
            DBObject src = (DBObject)object;
            for (String key : src.keySet()) {
                Object rawObject = src.get(key);
                Object dboValue = rawObject == null ? null : DBObjectUtil.toDBObject(rawObject.getClass(), rawObject, new Type[0]);
                dbo.put(key, dboValue);
            }
            return dbo;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return DBObjectUtil.wrapMap(DBObjectUtil.coalesceTypeParam(optionalValueTypes, 1), (Map)object);
        }
        if (List.class.isAssignableFrom(cls)) {
            return DBObjectUtil.wrapList(DBObjectUtil.coalesceTypeParam(optionalValueTypes, 0), (List)object);
        }
        if (Set.class.isAssignableFrom(cls)) {
            return DBObjectUtil.wrapSet(DBObjectUtil.coalesceTypeParam(optionalValueTypes, 0), (Set)object);
        }
        if (Iterable.class.isAssignableFrom(cls)) {
            return DBObjectUtil.wrapList(DBObjectUtil.coalesceTypeParam(optionalValueTypes, 0), (Iterable)object);
        }
        throw new IllegalStateException("Unanticipated object " + object + " and type " + cls);
    }

    private static Class<?> coalesceTypeParam(Type[] classes, int index) {
        return classes == null || index >= classes.length ? Object.class : classes[index];
    }

    private static Function<Object, Object> fromObjectFunction(final Class<?> type, final Class<?> ... typeParams) {
        return new Function<Object, Object>(){

            public Object apply(Object from) {
                return DBObjectUtil.fromObject(type, from, typeParams);
            }
        };
    }

    private static Map<Object, Object> wrapMap(final Type valueType, final Map<Object, Object> delegate) {
        return new ForwardingMap<Object, Object>(){

            protected Map<Object, Object> delegate() {
                return delegate;
            }

            public Object get(Object key) {
                return DBObjectUtil.toDBObject((Class)valueType, super.get(key), new Type[0]);
            }

            public Set<Map.Entry<Object, Object>> entrySet() {
                return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)super.entrySet(), (Function)new Function<Map.Entry<Object, Object>, Map.Entry<Object, Object>>(){

                    public Map.Entry<Object, Object> apply(Map.Entry<Object, Object> from) {
                        return new AbstractMap.SimpleEntry<Object, Object>(from.getKey(), DBObjectUtil.toDBObject((Class)valueType, from.getValue(), new Type[0]));
                    }
                }));
            }
        };
    }

    private static List<Object> wrapList(final Type valueType, Iterable<Object> delegate) {
        final ArrayList delegateList = Lists.newArrayList(delegate);
        return new ForwardingList<Object>(){

            protected List<Object> delegate() {
                return delegateList;
            }

            public Object get(int index) {
                return DBObjectUtil.toDBObject((Class)valueType, super.get(index), new Type[0]);
            }

            public Iterator<Object> iterator() {
                final Iterator delegateIterator = delegateList.iterator();
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return delegateIterator.hasNext();
                    }

                    @Override
                    public Object next() {
                        return DBObjectUtil.toDBObject((Class)valueType, delegateIterator.next(), new Type[0]);
                    }

                    @Override
                    public void remove() {
                        delegateIterator.remove();
                    }
                };
            }
        };
    }

    private static List<Object> wrapSet(Type valueType, Set<Object> delegate) {
        return DBObjectUtil.wrapList(valueType, Lists.newArrayList(delegate));
    }

    private static boolean needsNoConversion(Class<?> cls, Object obj) {
        return obj == null || cls.isArray() || NO_CONVERSION_CLASSES.contains(cls) || NO_CONVERSION_CLASSES.contains(obj.getClass()) || DBObject.class.isAssignableFrom(cls) && cls.isInstance(obj);
    }

    private static Map<?, ?> fromMap(Object source, Class<?> ... typeParameters) {
        if (DirtyableDBObjectMap.class.isAssignableFrom(source.getClass())) {
            return (Map)source;
        }
        Function<Object, Object> valueFunction = DBObjectUtil.fromObjectFunction(DBObjectUtil.coalesceTypeParam(typeParameters, 1), new Class[0]);
        if (String.class != DBObjectUtil.coalesceTypeParam(typeParameters, 0)) {
            Function<Object, Object> keyFunction = DBObjectUtil.fromObjectFunction(DBObjectUtil.coalesceTypeParam(typeParameters, 0), new Class[0]);
            Map sourceMap = (Map)source;
            DirtyableDBObjectMap converted = new DirtyableDBObjectMap();
            for (Map.Entry entry : sourceMap.entrySet()) {
                converted.put(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
            }
            converted.markPersisted();
            return converted;
        }
        return new DirtyableDBObjectMap(Maps.transformValues((Map)((Map)source), valueFunction));
    }

    private static Set<?> fromSet(Object source, Class<?> ... typeParameters) {
        if (DirtyableDBObjectSet.class.isAssignableFrom(source.getClass())) {
            return (Set)source;
        }
        Function<Object, Object> valueFunction = DBObjectUtil.fromObjectFunction(DBObjectUtil.coalesceTypeParam(typeParameters, 0), new Class[0]);
        return new DirtyableDBObjectSet(Sets.newHashSet((Iterable)Iterables.transform((Iterable)((Set)source), valueFunction)));
    }

    private static List<?> fromList(Object source, Class<?> ... typeParameters) {
        if (DirtyableDBObjectList.class.isAssignableFrom(source.getClass())) {
            return (List)source;
        }
        Function<Object, Object> valueFunction = DBObjectUtil.fromObjectFunction(DBObjectUtil.coalesceTypeParam(typeParameters, 0), new Class[0]);
        return new DirtyableDBObjectList(Lists.transform((List)((List)source), valueFunction));
    }

    static {
        Collections.addAll(NO_CONVERSION_CLASSES, Date.class, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Number.class, BigDecimal.class, BigInteger.class, String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Pattern.class, byte[].class, DBPointer.class, DBRefBase.class, ObjectId.class);
    }

    private static final class TypeDefinition {
        private final Class<?> clazz;
        private final Class<?>[] typeParameters;

        public TypeDefinition(Class<?> clazz, Type ... typeParametersAsType) {
            this.clazz = clazz;
            this.typeParameters = new Class[typeParametersAsType.length];
            for (int i = 0; i < this.typeParameters.length; ++i) {
                this.typeParameters[i] = (Class)typeParametersAsType[i];
            }
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Class<?>[] getTypeParameters() {
            return this.typeParameters;
        }
    }
}

