/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;

public class DirtyableDBObjectList
implements List,
DirtyableDBObject {
    private boolean dirty;
    private List delegate;

    public DirtyableDBObjectList() {
        this.delegate = new ArrayList();
    }

    public DirtyableDBObjectList(List delegate) {
        this.delegate = delegate;
    }

    public void add(int index, Object element) {
        this.dirty = true;
        this.delegate.add(index, element);
    }

    public boolean addAll(int index, Collection elements) {
        this.dirty = true;
        return this.delegate.addAll(index, elements);
    }

    public Object remove(int index) {
        Object removed = this.delegate.remove(index);
        this.dirty = true;
        return removed;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean changed = this.delegate.removeAll(collection);
        this.dirty |= changed;
        return changed;
    }

    public Object set(int index, Object element) {
        this.dirty = true;
        return this.delegate.set(index, element);
    }

    @Override
    public boolean add(Object element) {
        boolean changed = this.delegate.add(element);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public boolean remove(Object object) {
        boolean changed = this.delegate.remove(object);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public boolean addAll(Collection ts) {
        boolean changed = this.delegate.addAll(ts);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean changed = this.delegate.retainAll(collection);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public void clear() {
        if (!this.delegate.isEmpty()) {
            this.dirty = true;
        }
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return this.delegate.toArray(objects);
    }

    @Override
    public boolean containsAll(Collection objects) {
        return this.delegate.containsAll(objects);
    }

    public Object get(int i) {
        return this.delegate.get(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.delegate.listIterator();
    }

    public ListIterator listIterator(int i) {
        return this.delegate.listIterator(i);
    }

    public List subList(int i, int i1) {
        return this.delegate.subList(i, i1);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markPersisted() {
        this.dirty = false;
    }

    @Override
    public boolean isPersisted() {
        throw new RuntimeException("Can't determine persisted state.");
    }

    public void markAsPartialObject() {
        throw new RuntimeException("Can't mark DirtyableDBObjectList as partial");
    }

    public boolean isPartialObject() {
        return false;
    }

    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            keys.add(String.valueOf(i));
        }
        return keys;
    }

    public boolean containsField(String s) {
        int i = this.getInt(s, false);
        return i >= 0 && i < this.size();
    }

    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    public Object removeField(String s) {
        int i = this.getInt(s, true);
        if (i < 0 || i >= this.size()) {
            return null;
        }
        return this.remove(i);
    }

    public Map toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            result.put(key, this.get(key));
        }
        return result;
    }

    public Object get(String s) {
        int i = this.getInt(s, true);
        if (i < 0 || i >= this.size()) {
            return null;
        }
        return this.delegate.get(i);
    }

    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public Object put(String s, Object v) {
        int i = this.getInt(s, true);
        while (i >= this.size()) {
            this.delegate.add(null);
        }
        this.set(i, v);
        return v;
    }

    private int getInt(String s, boolean throwException) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            if (throwException) {
                throw new IllegalArgumentException("Unable to handle non-numeric value " + s);
            }
            return -1;
        }
    }
}

