/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;

public class DirtyableDBObjectSet
implements Set,
DirtyableDBObject {
    private Set delegate;
    private boolean dirty = false;

    public DirtyableDBObjectSet() {
        this.delegate = new HashSet();
    }

    public DirtyableDBObjectSet(Set delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return this.delegate.toArray(objects);
    }

    @Override
    public boolean add(Object o) {
        boolean changed = this.delegate.add(o);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.delegate.remove(o);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean changed = this.delegate.addAll(collection);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean changed = this.delegate.retainAll(collection);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean changed = this.delegate.removeAll(collection);
        this.dirty |= changed;
        return changed;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.dirty = true;
        }
        this.delegate.clear();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markPersisted() {
        this.dirty = false;
    }

    @Override
    public boolean isPersisted() {
        throw new RuntimeException("Can't determine persisted state.");
    }

    public void markAsPartialObject() {
        throw new RuntimeException("Can't mark DirtyableDBObjectSet as partial");
    }

    public boolean isPartialObject() {
        return false;
    }

    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Object o : this.delegate) {
            keys.add(o.toString());
        }
        return keys;
    }

    public boolean containsField(String s) {
        for (Object o : this.delegate) {
            if (!o.toString().equals(s)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    public Object removeField(String s) {
        Iterator iterator = this.delegate.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!o.toString().equals(s)) continue;
            iterator.remove();
            this.dirty = true;
            return o;
        }
        return null;
    }

    public Map toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            result.put(key, this.get(key));
        }
        return result;
    }

    public Object get(String s) {
        for (Object o : this.delegate) {
            if (!o.toString().equals(s)) continue;
            return o;
        }
        return null;
    }

    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public Object put(String s, Object v) {
        this.add(v);
        return v;
    }
}

