/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.projections;

import com.mongodb.DBObject;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.ProjectionType;
import org.iternine.jeppetto.dao.mongodb.MongoDBCommand;
import org.iternine.jeppetto.dao.mongodb.projections.AverageMapReduceCommand;
import org.iternine.jeppetto.dao.mongodb.projections.CountCommand;
import org.iternine.jeppetto.dao.mongodb.projections.CountDistinctMapReduceCommand;
import org.iternine.jeppetto.dao.mongodb.projections.MaximumMapReduceCommand;
import org.iternine.jeppetto.dao.mongodb.projections.MinimumMapReduceCommand;
import org.iternine.jeppetto.dao.mongodb.projections.RowCountCommand;
import org.iternine.jeppetto.dao.mongodb.projections.SumMapReduceCommand;

public final class ProjectionCommands {
    public static MongoDBCommand forProjection(Projection projection, DBObject query) {
        String field = projection.getField();
        switch ((ProjectionType)projection.getDetails()) {
            case Average: {
                return new AverageMapReduceCommand(query, field);
            }
            case Count: {
                return new CountCommand(query, field);
            }
            case CountDistinct: {
                return new CountDistinctMapReduceCommand(query, field);
            }
            case Maximum: {
                return new MaximumMapReduceCommand(query, field);
            }
            case Minimum: {
                return new MinimumMapReduceCommand(query, field);
            }
            case RowCount: {
                return new RowCountCommand(query);
            }
            case Sum: {
                return new SumMapReduceCommand(query, field);
            }
        }
        throw new UnsupportedOperationException(projection.getDetails() + " not supported.");
    }

    private ProjectionCommands() {
    }
}

