/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.DBObject;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class MongoDBSessionCache {
    private final Map<Map<String, String>, WeakReference> objectCache = new HashMap<Map<String, String>, WeakReference>();

    MongoDBSessionCache() {
    }

    public void put(DBObject key, Object object) {
        this.objectCache.put(this.flatten(key.toMap()), new WeakReference<Object>(object));
    }

    public Object get(DBObject key) {
        Map<String, String> flattenedKey = this.flatten(key.toMap());
        WeakReference reference = this.objectCache.get(flattenedKey);
        if (reference == null) {
            return null;
        }
        if (reference.get() == null) {
            this.objectCache.remove(flattenedKey);
            return null;
        }
        return reference.get();
    }

    public void clear() {
        this.objectCache.clear();
    }

    private Map<String, String> flatten(Map<String, ?> input) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : input.entrySet()) {
            for (Map.Entry<String, String> entry2 : this.flatten(entry)) {
                if (entry2.getValue() == null) continue;
                result.put(entry2.getKey(), entry2.getValue());
            }
        }
        return result;
    }

    private Iterable<? extends Map.Entry<String, String>> flatten(Map.Entry<String, ?> entry) {
        if (entry.getValue() instanceof DBObject) {
            return this.flatten(entry.getKey(), ((DBObject)entry.getValue()).toMap());
        }
        if (entry.getValue() != null) {
            return Collections.singletonList(new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue().toString()));
        }
        return Collections.emptyList();
    }

    private Iterable<? extends Map.Entry<String, String>> flatten(String key, Map<?, ?> value) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            for (Map.Entry<String, String> entry2 : this.flatten(new AbstractMap.SimpleEntry(key + '.' + entry.getKey(), entry.getValue()))) {
                result.put(entry2.getKey(), entry2.getValue());
            }
        }
        return result.entrySet();
    }
}

