/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.DBRefBase;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectList;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectMap;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectSet;
import org.iternine.jeppetto.dao.mongodb.enhance.EnhancerHelper;
import org.iternine.jeppetto.enhance.Enhancer;

public class DBObjectUtil {
    private static final Set<Class<?>> NO_CONVERSION_CLASSES = new HashSet();

    public static boolean objectIsMutable(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean needsNoConversion(Class clazz) {
        return NO_CONVERSION_CLASSES.contains(clazz);
    }

    public static Object fromObject(Class<?> type, Object o) {
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            if (List.class.isAssignableFrom(type)) {
                if (DirtyableDBObjectList.class.isAssignableFrom(o.getClass())) {
                    return o;
                }
                return new DirtyableDBObjectList((List)o, true);
            }
            if (Map.class.isAssignableFrom(type)) {
                if (DirtyableDBObjectMap.class.isAssignableFrom(o.getClass())) {
                    return o;
                }
                return new DirtyableDBObjectMap((Map)o);
            }
            if (Set.class.isAssignableFrom(type)) {
                if (DirtyableDBObjectSet.class.isAssignableFrom(o.getClass())) {
                    return o;
                }
                return new DirtyableDBObjectSet((Set)o, true);
            }
            return type.cast(o);
        }
        if (Iterable.class.isAssignableFrom(o.getClass()) && Set.class.isAssignableFrom(type)) {
            throw new JeppettoException();
        }
        if (o instanceof DBObject) {
            DBObject copy = (DBObject)EnhancerHelper.getDirtyableDBObjectEnhancer(type).newInstance();
            copy.putAll((BSONObject)((DBObject)o));
            return copy;
        }
        if (Enum.class.isAssignableFrom(type) && String.class.isAssignableFrom(o.getClass())) {
            return Enum.valueOf(type, (String)o);
        }
        if (BigDecimal.class == type && Number.class.isAssignableFrom(o.getClass())) {
            return BigDecimal.valueOf(((Number)o).doubleValue());
        }
        if (BigInteger.class == type && Number.class.isAssignableFrom(o.getClass())) {
            return BigInteger.valueOf(((Number)o).longValue());
        }
        throw new RuntimeException("Not sure how to convert a " + o + " to a " + type.getSimpleName());
    }

    public static Object toDBObject(Object object) {
        if (object == null || NO_CONVERSION_CLASSES.contains(object.getClass()) || DirtyableDBObject.class.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (Map.class.isAssignableFrom(object.getClass())) {
            return new DirtyableDBObjectMap((Map)object);
        }
        if (List.class.isAssignableFrom(object.getClass())) {
            return new DirtyableDBObjectList((List)object, true);
        }
        if (Set.class.isAssignableFrom(object.getClass())) {
            return new DirtyableDBObjectSet((Set)object, true);
        }
        if (Iterable.class.isAssignableFrom(object.getClass())) {
            throw new RuntimeException("oops...");
        }
        if (DBObject.class.isInstance(object)) {
            BasicDBObject dbo = new BasicDBObject();
            DBObject src = (DBObject)object;
            for (String key : src.keySet()) {
                Object rawObject = src.get(key);
                Object dboValue = rawObject == null ? null : DBObjectUtil.toDBObject(rawObject);
                dbo.put(key, dboValue);
            }
            return dbo;
        }
        if (Enum.class.isInstance(object)) {
            return ((Enum)object).name();
        }
        Enhancer<?> enhancer = EnhancerHelper.getDirtyableDBObjectEnhancer(object.getClass());
        return enhancer.enhance(object);
    }

    static {
        Collections.addAll(NO_CONVERSION_CLASSES, Date.class, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Number.class, BigDecimal.class, BigInteger.class, String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Pattern.class, byte[].class, DBPointer.class, DBRefBase.class, ObjectId.class);
    }
}

