/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import java.util.HashMap;
import java.util.Map;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;
import org.iternine.jeppetto.enhance.Enhancer;
import org.iternine.jeppetto.enhance.NoOpEnhancer;
import org.iternine.jeppetto.enhance.VelocityEnhancer;

public class EnhancerHelper {
    private static final Map<Class, Enhancer> dirtyableDBObjectEnhancers = new HashMap<Class, Enhancer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Enhancer<T> getDirtyableDBObjectEnhancer(Class<T> baseClass) {
        if (dirtyableDBObjectEnhancers.containsKey(baseClass)) {
            return dirtyableDBObjectEnhancers.get(baseClass);
        }
        Map<Class, Enhancer> map = dirtyableDBObjectEnhancers;
        synchronized (map) {
            Object enhancer;
            if (dirtyableDBObjectEnhancers.get(baseClass) != null) {
                enhancer = dirtyableDBObjectEnhancers.get(baseClass);
            } else if (DirtyableDBObject.class.isAssignableFrom(baseClass)) {
                enhancer = new NoOpEnhancer(baseClass);
                dirtyableDBObjectEnhancers.put(baseClass, (Enhancer)enhancer);
            } else {
                enhancer = new VelocityEnhancer<T>(baseClass){

                    public boolean needsEnhancement(Object object) {
                        return object != null && !(object instanceof DirtyableDBObject);
                    }

                    protected String getTemplateLocation() {
                        return "org/iternine/jeppetto/dao/mongodb/enhance/dirtyableDBObject.vm";
                    }
                };
                dirtyableDBObjectEnhancers.put(baseClass, (Enhancer)enhancer);
            }
            return enhancer;
        }
    }
}

