/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.AccessControlDAO;
import org.iternine.jeppetto.dao.AccessControlException;
import org.iternine.jeppetto.dao.AccessType;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.OptimisticLockException;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.ProjectionType;
import org.iternine.jeppetto.dao.QueryModel;
import org.iternine.jeppetto.dao.QueryModelDAO;
import org.iternine.jeppetto.dao.Sort;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.TooManyItemsException;
import org.iternine.jeppetto.dao.annotation.AccessControl;
import org.iternine.jeppetto.dao.annotation.Accessor;
import org.iternine.jeppetto.dao.annotation.Creator;
import org.iternine.jeppetto.dao.mongodb.BasicDBObjectCommand;
import org.iternine.jeppetto.dao.mongodb.MongoDBCommand;
import org.iternine.jeppetto.dao.mongodb.MongoDBOperator;
import org.iternine.jeppetto.dao.mongodb.MongoDBSession;
import org.iternine.jeppetto.dao.mongodb.QueryLoggingCommand;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectList;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectMap;
import org.iternine.jeppetto.dao.mongodb.enhance.EnhancerHelper;
import org.iternine.jeppetto.dao.mongodb.enhance.MongoDBDecoder;
import org.iternine.jeppetto.dao.mongodb.projections.ProjectionCommands;
import org.iternine.jeppetto.enhance.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBQueryModelDAO<T, ID>
implements QueryModelDAO<T, ID>,
AccessControlDAO<T, ID> {
    private static final String ID_FIELD = "_id";
    private static final String OPTIMISTIC_LOCK_VERSION_FIELD = "__olv";
    private static final String ACCESS_CONTROL_FIELD = "__acl";
    private static final Pattern READ_PATTERN = Pattern.compile("^R");
    private DBCollection dbCollection;
    private Enhancer<T> enhancer;
    private AccessControlContextProvider accessControlContextProvider;
    private Map<String, Set<String>> uniqueIndexes;
    private boolean optimisticLockEnabled;
    private List<String> shardKeys;
    private boolean saveNulls;
    private WriteConcern defaultWriteConcern;
    private Logger queryLogger;

    protected MongoDBQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties) {
        this(entityClass, daoProperties, null);
    }

    protected MongoDBQueryModelDAO(Class<T> entityClass, Map<String, Object> daoProperties, AccessControlContextProvider accessControlContextProvider) {
        String collectionName = daoProperties.containsKey("collection") ? (String)daoProperties.get("collection") : entityClass.getSimpleName();
        this.dbCollection = ((DB)daoProperties.get("db")).getCollection(collectionName);
        this.enhancer = EnhancerHelper.getDirtyableDBObjectEnhancer(entityClass);
        this.dbCollection.setObjectClass(this.enhancer.getEnhancedClass());
        this.dbCollection.setDBDecoderFactory(new DBDecoderFactory(){

            public DBDecoder create() {
                return new MongoDBDecoder();
            }
        });
        this.accessControlContextProvider = accessControlContextProvider;
        this.uniqueIndexes = this.ensureIndexes((List)daoProperties.get("uniqueIndexes"), true);
        this.ensureIndexes((List)daoProperties.get("nonUniqueIndexes"), false);
        this.optimisticLockEnabled = Boolean.parseBoolean((String)daoProperties.get("optimisticLockEnabled"));
        this.shardKeys = this.extractShardKeys((String)daoProperties.get("shardKeyPattern"));
        this.saveNulls = Boolean.parseBoolean((String)daoProperties.get("saveNulls"));
        this.defaultWriteConcern = daoProperties.containsKey("writeConcern") ? WriteConcern.valueOf((String)((String)daoProperties.get("writeConcern"))) : WriteConcern.SAFE;
        if (Boolean.parseBoolean((String)daoProperties.get("showQueries"))) {
            this.queryLogger = LoggerFactory.getLogger(this.getClass());
        }
    }

    public T findById(ID id) throws NoSuchItemException, JeppettoException {
        try {
            QueryModel queryModel = new QueryModel();
            queryModel.addCondition(this.buildIdCondition(id));
            if (this.accessControlContextProvider != null) {
                queryModel.setAccessControlContext(this.accessControlContextProvider.getCurrent());
            }
            return this.findUniqueUsingQueryModel(queryModel);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchItemException(this.getCollectionClass().getSimpleName(), id.toString());
        }
    }

    public Iterable<T> findAll() throws JeppettoException {
        QueryModel queryModel = new QueryModel();
        if (this.accessControlContextProvider != null) {
            queryModel.setAccessControlContext(this.accessControlContextProvider.getCurrent());
        }
        return this.findUsingQueryModel(queryModel);
    }

    public void save(T entity) throws OptimisticLockException, JeppettoException {
        Object enhancedEntity = this.enhancer.enhance(entity);
        DirtyableDBObject dbo = (DirtyableDBObject)enhancedEntity;
        if (dbo.isPersisted(this.dbCollection)) {
            if (this.accessControlContextProvider != null) {
                this.verifyWriteAllowed(dbo, this.accessControlContextProvider.getCurrent());
            }
        } else {
            if (dbo.get(ID_FIELD) == null) {
                dbo.put(ID_FIELD, new ObjectId());
            }
            if (this.accessControlContextProvider != null) {
                this.assessAndAssignAccessControl(dbo, this.accessControlContextProvider.getCurrent());
            }
        }
        DBObject identifyingQuery = this.buildIdentifyingQuery(dbo);
        if (MongoDBSession.isActive()) {
            MongoDBSession.trackForSave(this, identifyingQuery, enhancedEntity, this.createIdentifyingQueries(dbo));
        } else {
            this.trueSave(identifyingQuery, dbo);
        }
    }

    public void delete(T entity) throws JeppettoException {
        DBObject dbo = (DBObject)this.enhancer.enhance(entity);
        DBObject identifyingQuery = this.buildIdentifyingQuery(dbo);
        for (String shardKey : this.shardKeys) {
            identifyingQuery.put(shardKey, dbo.get(shardKey));
        }
        this.deleteByIdentifyingQuery(identifyingQuery);
    }

    public void deleteById(ID id) throws JeppettoException {
        this.deleteByIdentifyingQuery(this.buildIdentifyingQuery(id));
    }

    public void flush() throws JeppettoException {
        if (MongoDBSession.isActive()) {
            MongoDBSession.flush(this);
        }
    }

    public T findUniqueUsingQueryModel(QueryModel queryModel) throws NoSuchItemException, TooManyItemsException, JeppettoException {
        Object cached;
        MongoDBCommand command = this.buildCommand(queryModel, AccessType.Read);
        if (MongoDBSession.isActive() && (cached = MongoDBSession.getObjectFromCache(this.dbCollection.getName(), command.getQuery())) != null) {
            DBObject identifyingQuery = this.buildIdentifyingQuery((DBObject)cached);
            MongoDBSession.trackForSave(this, identifyingQuery, cached, this.createIdentifyingQueries((DBObject)cached));
            return (T)cached;
        }
        Object result = command.singleResult(this.dbCollection);
        ((DirtyableDBObject)result).markPersisted(this.dbCollection);
        if (MongoDBSession.isActive()) {
            DBObject identifyingQuery = this.buildIdentifyingQuery((DBObject)result);
            MongoDBSession.trackForSave(this, identifyingQuery, result, this.createIdentifyingQueries((DBObject)result));
        }
        return (T)result;
    }

    public Iterable<T> findUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        MongoDBCommand command = this.buildCommand(queryModel, AccessType.Read);
        DBCursor dbCursor = command.cursor(this.dbCollection);
        if (queryModel.getSorts() != null) {
            dbCursor.sort(this.processSorts(queryModel.getSorts()));
        }
        if (queryModel.getFirstResult() > 0) {
            dbCursor = dbCursor.skip(queryModel.getFirstResult());
        }
        if (queryModel.getMaxResults() > 0) {
            dbCursor = dbCursor.limit(queryModel.getMaxResults());
        }
        final DBCursor finalDbCursor = dbCursor;
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return finalDbCursor.hasNext();
                    }

                    @Override
                    public T next() {
                        DBObject result = finalDbCursor.next();
                        ((DirtyableDBObject)result).markPersisted(MongoDBQueryModelDAO.this.dbCollection);
                        if (MongoDBSession.isActive()) {
                            MongoDBSession.trackForSave(MongoDBQueryModelDAO.this, MongoDBQueryModelDAO.this.buildIdentifyingQuery(result), result, MongoDBQueryModelDAO.this.createIdentifyingQueries(result));
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        finalDbCursor.remove();
                    }
                };
            }
        };
    }

    public Object projectUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        try {
            return this.buildCommand(queryModel, AccessType.Read).singleResult(this.dbCollection);
        }
        catch (NoSuchItemException e) {
            return null;
        }
    }

    public void deleteUsingQueryModel(QueryModel queryModel) throws JeppettoException {
        try {
            BasicDBObject deleteQuery = this.buildQueryObject(queryModel, AccessType.ReadWrite);
            if (this.queryLogger != null) {
                this.queryLogger.debug("Deleting {}s identified by {}", new Object[]{this.getCollectionClass().getSimpleName(), deleteQuery.toMap()});
            }
            this.dbCollection.remove((DBObject)deleteQuery, this.getWriteConcern());
        }
        catch (MongoException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public Condition buildCondition(String conditionField, ConditionType conditionType, Iterator argsIterator) {
        if (conditionField.equals("id")) {
            return this.buildIdCondition(argsIterator.next());
        }
        return new Condition(conditionField, MongoDBOperator.valueOf(conditionType.name()).buildConstraint(argsIterator));
    }

    public Projection buildProjection(String projectionField, ProjectionType projectionType, Iterator argsIterator) {
        return new Projection(projectionField, (Object)projectionType);
    }

    public void save(T object, AccessControlContext accessControlContext) throws OptimisticLockException, AccessControlException, JeppettoException {
        this.ensureAccessControlEnabled();
        Object enhancedEntity = this.enhancer.enhance(object);
        DirtyableDBObject dbo = (DirtyableDBObject)enhancedEntity;
        if (dbo.isPersisted(this.dbCollection)) {
            this.verifyWriteAllowed(dbo, accessControlContext);
        } else {
            if (dbo.get(ID_FIELD) == null) {
                dbo.put(ID_FIELD, new ObjectId());
            }
            this.assessAndAssignAccessControl(dbo, accessControlContext);
        }
        DBObject identifyingQuery = this.buildIdentifyingQuery(dbo);
        if (MongoDBSession.isActive()) {
            MongoDBSession.trackForSave(this, identifyingQuery, enhancedEntity, this.createIdentifyingQueries(dbo));
        } else {
            this.trueSave(identifyingQuery, dbo);
        }
    }

    public void grantAccess(ID id, String accessId, AccessType accessType) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        this.grantAccess(id, accessId, accessType, this.accessControlContextProvider.getCurrent());
    }

    public void grantAccess(ID id, String accessId, AccessType accessType, AccessControlContext accessControlContext) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        if (accessType == AccessType.None) {
            this.revokeAccess(id, accessId, accessControlContext);
            return;
        }
        QueryModel queryModel = new QueryModel();
        queryModel.addCondition(this.buildIdCondition(id));
        queryModel.setAccessControlContext(accessControlContext);
        DBObject dbo = (DBObject)this.findUniqueUsingQueryModel(queryModel);
        this.verifyWriteAllowed(dbo, accessControlContext);
        Map accessControl = (Map)dbo.get(ACCESS_CONTROL_FIELD);
        BasicDBObject accessUpdate = accessControl == null ? new BasicDBObject("$set", (Object)new BasicDBObject(ACCESS_CONTROL_FIELD, (Object)new BasicDBObject(accessId, (Object)accessType.shortName()))) : new BasicDBObject("$set", (Object)new BasicDBObject("__acl." + accessId, (Object)accessType.shortName()));
        DBObject identifyingQuery = this.buildIdentifyingQuery(dbo);
        for (String shardKey : this.shardKeys) {
            identifyingQuery.put(shardKey, dbo.get(shardKey));
        }
        if (this.queryLogger != null) {
            this.queryLogger.info("Granting access to object identified by {} to {}.", (Object)identifyingQuery.toMap(), (Object)accessId);
        }
        try {
            this.dbCollection.update(identifyingQuery, (DBObject)accessUpdate, true, false, this.getWriteConcern());
        }
        catch (MongoException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public void revokeAccess(ID id, String accessId) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        this.revokeAccess(id, accessId, this.accessControlContextProvider.getCurrent());
    }

    public void revokeAccess(ID id, String accessId, AccessControlContext accessControlContext) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        QueryModel queryModel = new QueryModel();
        queryModel.addCondition(this.buildIdCondition(id));
        queryModel.setAccessControlContext(accessControlContext);
        DBObject dbo = (DBObject)this.findUniqueUsingQueryModel(queryModel);
        this.verifyWriteAllowed(dbo, accessControlContext);
        Map accessControl = (Map)dbo.get(ACCESS_CONTROL_FIELD);
        if (accessControl == null) {
            return;
        }
        BasicDBObject accessUpdate = new BasicDBObject("$pull", (Object)new BasicDBObject(ACCESS_CONTROL_FIELD, (Object)accessId));
        DBObject identifyingQuery = this.buildIdentifyingQuery(dbo);
        for (String shardKey : this.shardKeys) {
            identifyingQuery.put(shardKey, dbo.get(shardKey));
        }
        if (this.queryLogger != null) {
            this.queryLogger.info("Revoking access to object identified by {} to {}.", (Object)identifyingQuery.toMap(), (Object)accessId);
        }
        try {
            this.dbCollection.update(identifyingQuery, (DBObject)accessUpdate, true, false, this.getWriteConcern());
        }
        catch (MongoException e) {
            throw new JeppettoException((Throwable)e);
        }
    }

    public Map<String, AccessType> getGrantedAccesses(ID id) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        return this.getGrantedAccesses(id, this.accessControlContextProvider.getCurrent());
    }

    public Map<String, AccessType> getGrantedAccesses(ID id, AccessControlContext accessControlContext) throws NoSuchItemException, AccessControlException {
        this.ensureAccessControlEnabled();
        QueryModel queryModel = new QueryModel();
        queryModel.addCondition(this.buildIdCondition(id));
        queryModel.setAccessControlContext(accessControlContext);
        DBObject dbo = (DBObject)this.findUniqueUsingQueryModel(queryModel);
        this.verifyWriteAllowed(dbo, accessControlContext);
        Map accessControl = (Map)dbo.get(ACCESS_CONTROL_FIELD);
        if (accessControl == null || accessControl.size() == 0) {
            return Collections.emptyMap();
        }
        if (accessControl.size() == 1) {
            Map.Entry entry = accessControl.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), AccessType.getAccessTypeFromShortName((String)((String)entry.getValue())));
        }
        HashMap<String, AccessType> result = new HashMap<String, AccessType>();
        for (Map.Entry entry : accessControl.entrySet()) {
            result.put((String)entry.getKey(), AccessType.getAccessTypeFromShortName((String)((String)entry.getValue())));
        }
        return result;
    }

    public AccessControlContextProvider getAccessControlContextProvider() {
        return this.accessControlContextProvider;
    }

    protected DBObject augmentObjectCacheKey(DBObject key) {
        return key;
    }

    protected DBObject[] createIdentifyingQueries(DBObject dbo) {
        int uniqueIndexCount = this.uniqueIndexes.size() + 1;
        ArrayList<DBObject> queries = new ArrayList<DBObject>(uniqueIndexCount);
        queries.add(this.buildIdentifyingQuery(dbo));
        for (Set<String> indexFields : this.uniqueIndexes.values()) {
            BasicDBObject query = new BasicDBObject();
            for (String indexField : indexFields) {
                query.put(indexField, this.getFieldValueFrom(dbo, indexField));
            }
            queries.add(this.augmentObjectCacheKey((DBObject)query));
        }
        return queries.toArray(new DBObject[uniqueIndexCount]);
    }

    protected final DBObject buildIdentifyingQuery(DBObject dbo) {
        return this.buildIdentifyingQuery(dbo.get(ID_FIELD));
    }

    protected final DBObject buildIdentifyingQuery(ID id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        if (id instanceof String && ObjectId.isValid((String)((String)id))) {
            return new BasicDBObject(ID_FIELD, (Object)new ObjectId((String)id));
        }
        return new BasicDBObject(ID_FIELD, id);
    }

    protected final void deleteByIdentifyingQuery(DBObject identifyingQuery) {
        if (MongoDBSession.isActive()) {
            MongoDBSession.trackForDelete(this, identifyingQuery);
        } else {
            this.trueRemove(identifyingQuery);
        }
    }

    protected final void trueSave(DBObject identifyingQuery, DirtyableDBObject dbo) {
        if (this.optimisticLockEnabled) {
            Integer optimisticLockVersion = (Integer)dbo.get(OPTIMISTIC_LOCK_VERSION_FIELD);
            int optimisticLockVersionValue = optimisticLockVersion == null ? 0 : optimisticLockVersion;
            identifyingQuery.put(OPTIMISTIC_LOCK_VERSION_FIELD, (Object)optimisticLockVersionValue);
            dbo.put(OPTIMISTIC_LOCK_VERSION_FIELD, optimisticLockVersionValue + 1);
        }
        for (String shardKey : this.shardKeys) {
            identifyingQuery.put(shardKey, dbo.get(shardKey));
        }
        DBObject optimalDbo = this.determineOptimalDBObject(dbo);
        if (optimalDbo.keySet().size() == 0) {
            if (this.queryLogger != null) {
                this.queryLogger.debug("Bypassing save on object identified by {}; optimization rendered no changes.", (Object)identifyingQuery.toMap());
            }
            return;
        }
        if (this.queryLogger != null) {
            this.queryLogger.debug("Saving {} identified by {} with document {}", new Object[]{this.getCollectionClass().getSimpleName(), identifyingQuery.toMap(), optimalDbo.toMap()});
        }
        try {
            this.dbCollection.update(identifyingQuery, optimalDbo, true, false, this.getWriteConcern());
        }
        catch (MongoException.DuplicateKey e) {
            if (this.optimisticLockEnabled && e.getMessage().contains("$_id_")) {
                Integer localOptimisticLockVersion = (Integer)dbo.get(OPTIMISTIC_LOCK_VERSION_FIELD) - 1;
                if (localOptimisticLockVersion == 0) {
                    throw new JeppettoException((Throwable)e);
                }
                identifyingQuery.removeField(OPTIMISTIC_LOCK_VERSION_FIELD);
                DBObject result = this.dbCollection.findOne(identifyingQuery);
                if (result == null) {
                    throw new OptimisticLockException("Probably an OptimisticLockException, but conflicting object identified by " + identifyingQuery + " no longer exists.");
                }
                Integer remoteOptimisticLockVersion = (Integer)result.get(OPTIMISTIC_LOCK_VERSION_FIELD);
                if (remoteOptimisticLockVersion != null && remoteOptimisticLockVersion > localOptimisticLockVersion) {
                    throw new OptimisticLockException("Local version = " + localOptimisticLockVersion + ", remote version = " + remoteOptimisticLockVersion);
                }
            }
            throw new JeppettoException((Throwable)e);
        }
        catch (MongoException e) {
            throw new JeppettoException((Throwable)e);
        }
        dbo.markPersisted(this.dbCollection);
    }

    protected final void trueRemove(DBObject identifyingQuery) {
        if (this.optimisticLockEnabled) {
            // empty if block
        }
        if (this.queryLogger != null) {
            this.queryLogger.debug("Removing {}s matching {}", new Object[]{this.getCollectionClass().getSimpleName(), identifyingQuery.toMap()});
        }
        this.dbCollection.remove(identifyingQuery, this.getWriteConcern());
    }

    protected final DBCollection getDbCollection() {
        return this.dbCollection;
    }

    protected final Class<?> getCollectionClass() {
        return this.enhancer.getBaseClass();
    }

    private DBObject processSorts(List<Sort> sorts) {
        BasicDBObject orderBy = new BasicDBObject();
        for (Sort sort : sorts) {
            orderBy.put(sort.getField(), (Object)(sort.getSortDirection() == SortDirection.Ascending ? 1 : -1));
        }
        return orderBy;
    }

    private Condition buildIdCondition(Object argument) {
        if (argument instanceof String && ObjectId.isValid((String)((String)argument))) {
            return new Condition(ID_FIELD, (Object)new ObjectId((String)argument));
        }
        if (Iterable.class.isAssignableFrom(argument.getClass())) {
            ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
            for (Object argumentItem : (Iterable)argument) {
                if (argumentItem == null) {
                    objectIds.add(null);
                    continue;
                }
                if (argumentItem instanceof ObjectId) {
                    objectIds.add((ObjectId)argumentItem);
                    continue;
                }
                if (argumentItem instanceof String) {
                    objectIds.add(new ObjectId((String)argumentItem));
                    continue;
                }
                throw new IllegalArgumentException("Don't know how to handle class for 'id' mapping: " + argumentItem.getClass());
            }
            return new Condition(ID_FIELD, (Object)new BasicDBObject("$in", objectIds));
        }
        return new Condition(ID_FIELD, argument);
    }

    private Object getFieldValueFrom(DBObject dbo, String field) {
        String subField;
        if (!field.contains(".")) {
            return dbo.get(field);
        }
        Object value = dbo;
        String[] arr$ = field.split(".");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (value = value.get(subField = arr$[i$])) != null; ++i$) {
        }
        return value;
    }

    private MongoDBCommand buildCommand(QueryModel queryModel, AccessType accessType) {
        BasicDBObject query = this.buildQueryObject(queryModel, accessType);
        MongoDBCommand command = queryModel.getProjection() == null ? new BasicDBObjectCommand(query) : ProjectionCommands.forProjection(queryModel.getProjection(), (DBObject)query);
        if (this.queryLogger != null) {
            return QueryLoggingCommand.wrap(command, this.queryLogger);
        }
        return command;
    }

    private Map<String, Set<String>> ensureIndexes(List<String> uniqueIndexes, boolean unique) {
        if (uniqueIndexes == null || uniqueIndexes.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String uniqueIndex : uniqueIndexes) {
            String[] indexFields;
            BasicDBObject index = new BasicDBObject();
            for (String indexField : indexFields = uniqueIndex.split(",")) {
                if ((indexField = indexField.trim()).startsWith("+")) {
                    index.put(indexField.substring(1), (Object)1);
                    continue;
                }
                if (indexField.startsWith("-")) {
                    index.put(indexField.substring(1), (Object)-1);
                    continue;
                }
                index.put(indexField, (Object)1);
            }
            result.put(uniqueIndex, index.keySet());
            if (this.queryLogger != null) {
                this.queryLogger.debug("Ensuring index {} on {}", new Object[]{index.toMap(), this.getCollectionClass().getSimpleName()});
            }
            this.dbCollection.ensureIndex((DBObject)index, this.createIndexName(uniqueIndex), unique);
        }
        return result;
    }

    private String createIndexName(String indexSpec) {
        return indexSpec.replace(',', '-');
    }

    private List<String> extractShardKeys(String shardKeyPattern) {
        if (shardKeyPattern == null) {
            return Collections.emptyList();
        }
        String[] shardKeyParts = shardKeyPattern.split(",");
        ArrayList<String> shardKeys = new ArrayList<String>(shardKeyParts.length);
        for (String shardKey : shardKeyParts) {
            if ((shardKey = shardKey.trim()).equals("id") || shardKey.equals(ID_FIELD)) continue;
            shardKeys.add(shardKey);
        }
        return shardKeys;
    }

    private BasicDBObject buildQueryObject(QueryModel queryModel, AccessType accessType) {
        BasicDBObject query = new BasicDBObject();
        ArrayList<Condition> allCriteria = new ArrayList<Condition>();
        if (queryModel.getConditions() != null) {
            allCriteria.addAll(queryModel.getConditions());
        }
        for (Map.Entry associationConditions : queryModel.getAssociationConditions().entrySet()) {
            for (Condition condition : (List)associationConditions.getValue()) {
                condition.setField((String)associationConditions.getKey() + "." + condition.getField());
                allCriteria.add(condition);
            }
        }
        for (Condition condition : allCriteria) {
            Object rawConstraint = condition.getConstraint();
            Object constraint = rawConstraint == null ? null : DBObjectUtil.toDBObject(rawConstraint);
            query.put(condition.getField(), constraint);
        }
        if (this.accessControlContextProvider != null && !this.annotationAllowsAccess(queryModel.getAccessControlContext(), accessType)) {
            if (accessType == AccessType.Read) {
                query.put("__acl." + queryModel.getAccessControlContext().getAccessId(), (Object)READ_PATTERN);
            } else {
                query.put("__acl." + queryModel.getAccessControlContext().getAccessId(), (Object)accessType.shortName());
            }
        }
        return query;
    }

    private DBObject determineOptimalDBObject(DirtyableDBObject dirtyableDBObject) {
        if (!dirtyableDBObject.isPersisted(this.dbCollection)) {
            return dirtyableDBObject;
        }
        BasicDBObject settableItems = new BasicDBObject();
        BasicDBObject unsettableItems = new BasicDBObject();
        this.walkDirtyableDBObject("", dirtyableDBObject, (DBObject)settableItems, (DBObject)unsettableItems);
        if (this.optimisticLockEnabled) {
            settableItems.put(OPTIMISTIC_LOCK_VERSION_FIELD, dirtyableDBObject.get(OPTIMISTIC_LOCK_VERSION_FIELD));
        }
        BasicDBObject optimalDBObject = new BasicDBObject();
        if (settableItems.keySet().size() > 0) {
            optimalDBObject.put("$set", (Object)settableItems);
        }
        if (unsettableItems.keySet().size() > 0) {
            optimalDBObject.put("$unset", (Object)unsettableItems);
        }
        return optimalDBObject;
    }

    private void walkDirtyableDBObject(String prefix, DirtyableDBObject dirtyableDBObject, DBObject settableItems, DBObject unsettableItems) {
        Iterator<String> dirtyKeys = dirtyableDBObject.getDirtyKeys();
        while (dirtyKeys.hasNext()) {
            String dirtyKey = dirtyKeys.next();
            Object dirtyObject = dirtyableDBObject.get(dirtyKey);
            if (dirtyObject instanceof DirtyableDBObjectList) {
                DirtyableDBObjectList dirtyableDBObjectList = (DirtyableDBObjectList)dirtyObject;
                if (!dirtyableDBObjectList.isPersisted(this.dbCollection) || dirtyableDBObjectList.isRewrite()) {
                    settableItems.put(prefix + dirtyKey, (Object)dirtyableDBObjectList);
                    continue;
                }
                this.walkDirtyableDBObject(prefix + dirtyKey + ".", dirtyableDBObjectList, settableItems, unsettableItems);
                continue;
            }
            if (dirtyObject instanceof DirtyableDBObjectMap) {
                DirtyableDBObjectMap dirtyableDBObjectMap = (DirtyableDBObjectMap)dirtyObject;
                if (!dirtyableDBObjectMap.isPersisted(this.dbCollection)) {
                    settableItems.put(prefix + dirtyKey, (Object)dirtyableDBObjectMap);
                    continue;
                }
                for (Object removedKey : dirtyableDBObjectMap.getRemovedKeys()) {
                    unsettableItems.put(prefix + dirtyKey + "." + removedKey, (Object)1);
                }
                this.walkDirtyableDBObject(prefix + dirtyKey + ".", dirtyableDBObjectMap, settableItems, unsettableItems);
                continue;
            }
            if (dirtyObject instanceof DirtyableDBObject) {
                if (!((DirtyableDBObject)dirtyObject).isPersisted(this.dbCollection)) {
                    settableItems.put(prefix + dirtyKey, dirtyObject);
                    continue;
                }
                this.walkDirtyableDBObject(prefix + dirtyKey + ".", (DirtyableDBObject)dirtyObject, settableItems, unsettableItems);
                continue;
            }
            settableItems.put(prefix + dirtyKey, DBObjectUtil.toDBObject(dirtyObject));
        }
    }

    private WriteConcern getWriteConcern() {
        return this.defaultWriteConcern;
    }

    private void ensureAccessControlEnabled() {
        if (this.accessControlContextProvider == null) {
            throw new AccessControlException("Access Control is not enabled. No AccessControlContextProvider specified.");
        }
    }

    private void verifyWriteAllowed(DBObject dbo, AccessControlContext accessControlContext) throws AccessControlException {
        Map accessControl = (Map)dbo.get(ACCESS_CONTROL_FIELD);
        if (accessControlContext == null || !AccessType.ReadWrite.shortName().equals(accessControl.get(accessControlContext.getAccessId())) && !this.annotationAllowsAccess(accessControlContext, AccessType.ReadWrite)) {
            throw new AccessControlException("Unable to write " + dbo.toMap() + " with " + accessControlContext);
        }
    }

    private void assessAndAssignAccessControl(DBObject dbo, AccessControlContext accessControlContext) throws AccessControlException {
        AccessControl accessControl = this.getAccessControlAnnotation();
        if (accessControl != null) {
            block5: for (Creator creator : accessControl.creators()) {
                switch (creator.type()) {
                    case Identified: {
                        if (accessControlContext.getAccessId() == null) continue block5;
                        dbo.put(ACCESS_CONTROL_FIELD, Collections.singletonMap(accessControlContext.getAccessId(), creator.grantedAccess().shortName()));
                        return;
                    }
                    case Role: {
                        if (accessControlContext.getRoles() == null || !accessControlContext.getRoles().contains(creator.typeValue())) continue block5;
                        dbo.put(ACCESS_CONTROL_FIELD, Collections.singletonMap(accessControlContext.getAccessId(), creator.grantedAccess().shortName()));
                        return;
                    }
                    case Anonymous: {
                        dbo.put(ACCESS_CONTROL_FIELD, Collections.emptyMap());
                        return;
                    }
                }
            }
            throw new AccessControlException("Unable to create " + dbo.getClass().getSuperclass().getSimpleName() + " with " + accessControlContext + ".  Check object's @AccessControl annotation.");
        }
        if (accessControlContext.getAccessId() == null) {
            dbo.put(ACCESS_CONTROL_FIELD, Collections.emptyMap());
        } else {
            dbo.put(ACCESS_CONTROL_FIELD, Collections.singletonMap(accessControlContext.getAccessId(), AccessType.ReadWrite.shortName()));
        }
    }

    private boolean annotationAllowsAccess(AccessControlContext accessControlContext, AccessType accessType) {
        if (accessType == null) {
            return false;
        }
        AccessControl accessControl = this.getAccessControlAnnotation();
        if (accessControl == null) {
            return false;
        }
        Set roles = accessControlContext == null ? Collections.emptySet() : accessControlContext.getRoles();
        for (Accessor accessor : accessControl.accessors()) {
            if (!accessor.access().allows(accessType) || accessor.type() != Accessor.Type.Anyone && (accessor.type() != Accessor.Type.Role || roles == null || !roles.contains(accessor.typeValue()))) continue;
            return true;
        }
        return false;
    }

    private AccessControl getAccessControlAnnotation() {
        for (Class<?> daoInterface : this.getClass().getInterfaces()) {
            AccessControl accessControl = daoInterface.getAnnotation(AccessControl.class);
            if (accessControl == null) continue;
            return accessControl;
        }
        return null;
    }
}

