/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.TooManyItemsException;
import org.iternine.jeppetto.dao.mongodb.MongoDBCommand;
import org.slf4j.Logger;

public final class QueryLoggingCommand
extends MongoDBCommand {
    private final MongoDBCommand delegate;
    private final Logger logger;

    private QueryLoggingCommand(MongoDBCommand delegate, Logger logger) {
        this.delegate = delegate;
        this.logger = logger;
    }

    public static MongoDBCommand wrap(MongoDBCommand command, Logger logger) {
        return new QueryLoggingCommand(command, logger);
    }

    @Override
    public DBCursor cursor(DBCollection dbCollection) {
        this.logger.debug("Executing {} for {} cursor", (Object)this.delegate, (Object)dbCollection.getFullName());
        DBCursor dbCursor = this.delegate.cursor(dbCollection);
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            DBObject plan = dbCursor.explain();
            sb.append("MongoDB query plan:\n");
            sb.append("\tcursor = \"").append(plan.get("cursor")).append("\"\n");
            sb.append("\tnscanned = \"").append(plan.get("nscanned")).append("\"\n");
            sb.append("\tn = \"").append(plan.get("n")).append("\"\n");
            sb.append("\tmillis = \"").append(plan.get("millis")).append("\"\n");
            this.logger.debug(sb.toString());
        }
        return dbCursor;
    }

    @Override
    public Object singleResult(DBCollection dbCollection) throws NoSuchItemException, TooManyItemsException {
        this.logger.debug("Executing {} for single {}", (Object)this.delegate, (Object)dbCollection.getName());
        return this.delegate.singleResult(dbCollection);
    }

    @Override
    public DBObject getQuery() {
        return this.delegate.getQuery();
    }
}

