/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectList;

public class DirtyableDBObjectSet
extends DirtyableDBObjectList
implements Set {
    private Set delegate;

    public DirtyableDBObjectSet() {
        this.delegate = new HashSet();
    }

    public DirtyableDBObjectSet(Set delegate, boolean modifiableDelegate) {
        super(new ArrayList(delegate), modifiableDelegate);
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public Iterator iterator() {
        final Iterator iterator = super.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                Object next = iterator.next();
                DirtyableDBObjectSet.this.delegate.remove(next);
                iterator.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return super.toArray();
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return super.toArray(objects);
    }

    @Override
    public boolean add(Object element) {
        if (this.delegate.add(element)) {
            super.add(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object element) {
        if (this.delegate.remove(element)) {
            super.remove(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection elements) {
        boolean changed = false;
        for (Object element : elements) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection elements) {
        throw new JeppettoException("Not implemented");
    }

    @Override
    public boolean removeAll(Collection elements) {
        boolean changed = false;
        for (Object element : elements) {
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public void clear() {
        super.clear();
        this.delegate.clear();
    }

    @Override
    public Object removeField(String s) {
        Object o = super.removeField(s);
        if (o != null) {
            this.delegate.remove(o);
        }
        return o;
    }

    @Override
    public Object put(String s, Object v) {
        super.put(s, v);
        this.delegate.add(v);
        return v;
    }
}

