/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.projections;

import com.mongodb.DBObject;
import org.iternine.jeppetto.dao.mongodb.projections.MapReduceCommand;

class CountDistinctMapReduceCommand
extends MapReduceCommand {
    private String field;

    public CountDistinctMapReduceCommand(DBObject query, String field) {
        super(query);
        this.field = field;
    }

    @Override
    protected Integer defaultValue() {
        return 0;
    }

    @Override
    protected String createMapFunction() {
        return String.format("function() { emit( this.%1$s, 1 ); }", this.field);
    }

    @Override
    protected String createReduceFunction() {
        return "function(k,v) { var sum=0; for(var i in v) {     sum += v[i]; } return sum; }";
    }

    @Override
    protected Integer transformToValue(Iterable<DBObject> results) {
        int i = 0;
        for (DBObject dbObject : results) {
            ++i;
        }
        return i;
    }

    @Override
    protected Integer transformToValue(DBObject dbObject) {
        throw new IllegalStateException("This method should not be invoked.");
    }
}

