/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.mongodb.DBCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.util.StringRangeSet;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;

public class DirtyableDBObjectList
implements List,
DirtyableDBObject {
    private List delegate;
    private boolean rewrite = false;
    private Set<Integer> modifiedIndexes = new HashSet<Integer>();
    private int firstAppendedIndex;
    private boolean modifiableDelegate;
    private DBCollection persistentCollection;

    public DirtyableDBObjectList() {
        this(new ArrayList(), false);
    }

    public DirtyableDBObjectList(List delegate, boolean modifiableDelegate) {
        this.delegate = delegate;
        this.firstAppendedIndex = delegate.size();
        this.modifiableDelegate = modifiableDelegate;
    }

    public void add(int index, Object element) {
        this.rewrite |= index < this.delegate.size();
        this.delegate.add(index, element);
    }

    public boolean addAll(int index, Collection elements) {
        this.rewrite |= index < this.delegate.size();
        return this.delegate.addAll(index, elements);
    }

    public Object remove(int index) {
        Object removed = this.delegate.remove(index);
        this.rewrite |= index < this.firstAppendedIndex;
        return removed;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean changed = this.delegate.removeAll(collection);
        this.rewrite |= changed;
        return changed;
    }

    public Object set(int index, Object element) {
        if (index < this.firstAppendedIndex) {
            this.modifiedIndexes.add(index);
        }
        return this.delegate.set(index, element);
    }

    @Override
    public boolean add(Object element) {
        return this.delegate.add(element);
    }

    @Override
    public boolean remove(Object object) {
        boolean changed = this.delegate.remove(object);
        this.rewrite |= changed;
        return changed;
    }

    @Override
    public boolean addAll(Collection elements) {
        return this.delegate.addAll(elements);
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean changed = this.delegate.retainAll(collection);
        this.rewrite |= changed;
        return changed;
    }

    @Override
    public void clear() {
        this.rewrite = true;
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return this.delegate.toArray(objects);
    }

    @Override
    public boolean containsAll(Collection objects) {
        return this.delegate.containsAll(objects);
    }

    public Object get(int index) {
        Object element = this.delegate.get(index);
        if (element == null || element instanceof DirtyableDBObject || DBObjectUtil.needsNoConversion(element.getClass())) {
            return element;
        }
        Object converted = DBObjectUtil.toDBObject(element);
        this.delegate.set(index, converted);
        return converted;
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private ListIterator delegateIterator;
            private int modifiableIndex;
            {
                this.delegateIterator = DirtyableDBObjectList.this.delegate.listIterator(index);
                this.modifiableIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Object next() {
                this.modifiableIndex = this.delegateIterator.nextIndex();
                Object next = this.delegateIterator.next();
                if (next instanceof DirtyableDBObject || DBObjectUtil.needsNoConversion(next.getClass())) {
                    return next;
                }
                Object converted = DBObjectUtil.toDBObject(next);
                DirtyableDBObjectList.this.delegate.set(this.modifiableIndex, converted);
                return converted;
            }

            @Override
            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            public Object previous() {
                this.modifiableIndex = this.delegateIterator.previousIndex();
                Object previous = this.delegateIterator.previous();
                if (previous instanceof DirtyableDBObject || DBObjectUtil.needsNoConversion(previous.getClass())) {
                    return previous;
                }
                Object converted = DBObjectUtil.toDBObject(previous);
                DirtyableDBObjectList.this.delegate.set(this.modifiableIndex, converted);
                return converted;
            }

            @Override
            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            @Override
            public void remove() {
                if (this.modifiableIndex < 0) {
                    throw new IllegalStateException("Iterator is not in a modifiable state.  Did you call next()/previous()?");
                }
                DirtyableDBObjectList.this.remove(this.modifiableIndex);
                this.modifiableIndex = -1;
            }

            public void set(Object o) {
                if (this.modifiableIndex < 0) {
                    throw new IllegalStateException("Iterator is not in a modifiable state.  Did you call next()/previous()?");
                }
                DirtyableDBObjectList.this.set(this.modifiableIndex, o);
                this.modifiableIndex = -1;
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public boolean isDirty() {
        return this.rewrite || this.delegate.size() > this.firstAppendedIndex || !this.modifiedIndexes.isEmpty() || this.getDirtyKeys().hasNext();
    }

    @Override
    public void markPersisted(DBCollection dbCollection) {
        for (Object object : this.delegate) {
            if (!(object instanceof DirtyableDBObject)) continue;
            DirtyableDBObject dirtyableDBObject = (DirtyableDBObject)object;
            dirtyableDBObject.markPersisted(dbCollection);
        }
        this.rewrite = false;
        this.modifiedIndexes.clear();
        this.firstAppendedIndex = this.delegate.size();
        this.persistentCollection = dbCollection;
    }

    @Override
    public boolean isPersisted(DBCollection dbCollection) {
        return dbCollection.equals((Object)this.persistentCollection);
    }

    @Override
    public Iterator<String> getDirtyKeys() {
        return new Iterator<String>(){
            private Iterator delegateIterator;
            private int i;
            {
                this.delegateIterator = DirtyableDBObjectList.this.delegate.iterator();
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                while (this.delegateIterator.hasNext()) {
                    Object object = this.delegateIterator.next();
                    if (++this.i < DirtyableDBObjectList.this.firstAppendedIndex && !DirtyableDBObjectList.this.modifiedIndexes.contains(this.i) && object instanceof DirtyableDBObject && !((DirtyableDBObject)object).isDirty()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                return Integer.toString(this.i);
            }

            @Override
            public void remove() {
                throw new JeppettoException("Can't remove items from dirtyKeys");
            }
        };
    }

    public void markAsPartialObject() {
        throw new JeppettoException("Can't mark DirtyableDBObjectList as partial");
    }

    public boolean isPartialObject() {
        return false;
    }

    public Set<String> keySet() {
        return new StringRangeSet(this.delegate.size());
    }

    public boolean containsField(String s) {
        return this.getNonNegativeInt(s) < this.size();
    }

    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    public Object removeField(String s) {
        int i = this.getNonNegativeInt(s);
        if (i >= this.size()) {
            return null;
        }
        return this.remove(i);
    }

    public Map toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            result.put(key, this.get(key));
        }
        return result;
    }

    public Object get(String s) {
        return this.get(this.getNonNegativeInt(s));
    }

    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public Object put(String s, Object v) {
        int i = this.getNonNegativeInt(s);
        while (i > this.size()) {
            this.delegate.add(null);
        }
        this.delegate.add(v);
        return v;
    }

    public boolean isRewrite() {
        return this.rewrite;
    }

    private int getNonNegativeInt(String s) {
        int i;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to handle non-numeric value " + s);
        }
        if (i < 0) {
            throw new IllegalArgumentException(s + " is an invalid index value");
        }
        return i;
    }
}

