/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.mongodb.DBCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;

public class DirtyableDBObjectMap
implements Map,
DirtyableDBObject {
    private Map<String, Object> delegate;
    private Set<String> addedOrUpdatedKeys = new HashSet<String>();
    private Set<String> removedKeys = new HashSet<String>();
    private DBCollection persistentCollection;

    public DirtyableDBObjectMap() {
        this(new HashMap<String, Object>());
    }

    public DirtyableDBObjectMap(Map<String, Object> delegate) {
        this.delegate = delegate;
    }

    public Object put(Object key, Object value) {
        String stringKey = (String)key;
        this.addedOrUpdatedKeys.add(stringKey);
        return this.delegate.put(stringKey, value);
    }

    public Object remove(Object key) {
        String stringKey = (String)key;
        Object result = this.delegate.remove(stringKey);
        if (result != null) {
            this.removedKeys.add(stringKey);
        }
        return result;
    }

    public void putAll(Map m) {
        Iterator i$ = m.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.removedKeys.addAll(this.delegate.keySet());
        this.addedOrUpdatedKeys.clear();
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Object get(Object key) {
        Object value = this.delegate.get(key);
        if (value == null || value instanceof DirtyableDBObject || DBObjectUtil.needsNoConversion(value.getClass())) {
            return value;
        }
        Object converted = DBObjectUtil.toDBObject(value);
        this.delegate.put((String)key, converted);
        return converted;
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    private Iterator<Map.Entry<String, Object>> delegateIterator;
                    private String currentKey;
                    {
                        this.delegateIterator = DirtyableDBObjectMap.this.delegate.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        Object currentValue;
                        Map.Entry<String, Object> current = this.delegateIterator.next();
                        this.currentKey = current.getKey();
                        if (current.getValue() instanceof DirtyableDBObject || DBObjectUtil.needsNoConversion(current.getValue().getClass())) {
                            currentValue = current.getValue();
                        } else {
                            currentValue = DBObjectUtil.toDBObject(current.getValue());
                            DirtyableDBObjectMap.this.delegate.put(this.currentKey, currentValue);
                        }
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return currentKey;
                            }

                            @Override
                            public Object getValue() {
                                return currentValue;
                            }

                            @Override
                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        DirtyableDBObjectMap.this.remove(this.currentKey);
                    }
                };
            }

            @Override
            public int size() {
                return DirtyableDBObjectMap.this.delegate.size();
            }

            @Override
            public boolean remove(Object o) {
                return DirtyableDBObjectMap.this.remove(o) != null;
            }

            @Override
            public void clear() {
                DirtyableDBObjectMap.this.clear();
            }
        };
    }

    @Override
    public boolean isDirty() {
        return !this.addedOrUpdatedKeys.isEmpty() || !this.removedKeys.isEmpty() || this.getDirtyKeys().hasNext();
    }

    @Override
    public void markPersisted(DBCollection dbCollection) {
        this.addedOrUpdatedKeys.clear();
        this.removedKeys.clear();
        for (Map.Entry<String, Object> o : this.delegate.entrySet()) {
            Map.Entry<String, Object> entry = o;
            if (this.addedOrUpdatedKeys.contains(entry.getKey()) || !(entry.getValue() instanceof DirtyableDBObject)) continue;
            DirtyableDBObject dirtyableDBObject = (DirtyableDBObject)entry.getValue();
            dirtyableDBObject.markPersisted(dbCollection);
        }
        this.persistentCollection = dbCollection;
    }

    @Override
    public boolean isPersisted(DBCollection dbCollection) {
        return dbCollection.equals((Object)this.persistentCollection);
    }

    @Override
    public Iterator<String> getDirtyKeys() {
        return new Iterator<String>(){
            private Iterator<Map.Entry<String, Object>> entries;
            private Map.Entry<String, Object> entry;
            {
                this.entries = DirtyableDBObjectMap.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.entries.hasNext()) {
                    this.entry = this.entries.next();
                    if (!DirtyableDBObjectMap.this.addedOrUpdatedKeys.contains(this.entry.getKey()) && (!(this.entry.getValue() instanceof DirtyableDBObject) || !((DirtyableDBObject)this.entry.getValue()).isDirty() && ((DirtyableDBObject)this.entry.getValue()).isPersisted(DirtyableDBObjectMap.this.persistentCollection)) && !(this.entry.getValue() instanceof byte[])) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                return this.entry.getKey();
            }

            @Override
            public void remove() {
                throw new JeppettoException("Can't remove items from dirtyKeys");
            }
        };
    }

    public void markAsPartialObject() {
        throw new JeppettoException("Can't mark DirtyableDBObjectMap as partial");
    }

    public boolean isPartialObject() {
        return false;
    }

    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    public void putAll(BSONObject bsonObject) {
        Iterator i$ = bsonObject.toMap().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            this.delegate.put((String)entry.getKey(), entry.getValue());
        }
    }

    public Object get(String key) {
        return this.get((Object)key);
    }

    public Map toMap() {
        return this;
    }

    public Object removeField(String key) {
        return this.remove(key);
    }

    public boolean containsKey(String key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsField(String field) {
        return this.delegate.containsKey(field);
    }

    public Set getRemovedKeys() {
        return this.removedKeys;
    }
}

