/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.TooManyItemsException;
import org.iternine.jeppetto.dao.mongodb.MongoDBCommand;

public class BasicDBObjectCommand
extends MongoDBCommand {
    private BasicDBObject query;
    private BasicDBObject fieldsToRetrieve;
    private DBDecoderFactory decoderFactory;

    public BasicDBObjectCommand(BasicDBObject query, BasicDBObject fieldsToRetrieve, DBDecoderFactory decoderFactory) {
        this.query = query;
        this.fieldsToRetrieve = fieldsToRetrieve;
        this.decoderFactory = decoderFactory;
    }

    @Override
    public DBCursor cursor(DBCollection dbCollection) {
        return dbCollection.find((DBObject)this.query, (DBObject)this.fieldsToRetrieve).setDecoderFactory(this.decoderFactory);
    }

    @Override
    public Object singleResult(DBCollection dbCollection) throws NoSuchItemException, TooManyItemsException {
        DBCursor cursor = this.cursor(dbCollection);
        cursor.limit(2);
        if (!cursor.hasNext()) {
            throw new NoSuchItemException(dbCollection.getName(), this.query.toString());
        }
        DBObject result = cursor.next();
        if (cursor.hasNext()) {
            throw new TooManyItemsException(dbCollection.getName(), this.query.toString());
        }
        return result;
    }

    @Override
    public DBObject getQuery() {
        return this.query;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(' ');
        sb.append(this.query);
        if (this.fieldsToRetrieve != null) {
            sb.append(" for fields ");
            sb.append(this.fieldsToRetrieve);
        }
        return sb.toString();
    }
}

