/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public enum MongoDBOperator {
    NotEqual("$ne"),
    GreaterThanEqual("$gte"),
    LessThanEqual("$lte"),
    Equal(null),
    GreaterThan("$gt"),
    LessThan("$lt"),
    NotWithin("$nin"),
    Within("$in"),
    Between(null),
    IsNull(null),
    IsNotNull(null),
    ElementMatches("$elemMatch");

    private String operator;

    private MongoDBOperator(String operator) {
        this.operator = operator;
    }

    public Object buildConstraint(Iterator argsIterator) {
        switch (this) {
            case Equal: {
                return this.translateEnumsIfNecessary(argsIterator.next());
            }
            case NotEqual: 
            case GreaterThan: 
            case GreaterThanEqual: 
            case LessThan: 
            case LessThanEqual: 
            case Within: 
            case NotWithin: 
            case ElementMatches: {
                return new BasicDBObject(this.operator, this.translateEnumsIfNecessary(argsIterator.next()));
            }
            case Between: {
                BasicDBObject betweenConstraint = new BasicDBObject();
                betweenConstraint.put(MongoDBOperator.GreaterThan.operator, this.translateEnumsIfNecessary(argsIterator.next()));
                betweenConstraint.put(MongoDBOperator.LessThan.operator, this.translateEnumsIfNecessary(argsIterator.next()));
                return betweenConstraint;
            }
            case IsNull: {
                BasicDBObject nullConstraint = new BasicDBObject();
                nullConstraint.put("$exists", (Object)Boolean.TRUE);
                nullConstraint.put("$type", (Object)10);
                return nullConstraint;
            }
            case IsNotNull: {
                BasicDBObject notNullConstraint = new BasicDBObject();
                notNullConstraint.put("$exists", (Object)Boolean.TRUE);
                notNullConstraint.put("$not", (Object)new BasicDBObject("$type", (Object)10));
                return notNullConstraint;
            }
        }
        throw new IllegalArgumentException("Unexpected enumeration: " + (Object)((Object)this));
    }

    private Object translateEnumsIfNecessary(Object argument) {
        if (argument == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(argument.getClass())) {
            return ((Enum)argument).name();
        }
        if (List.class.isAssignableFrom(argument.getClass()) && ((List)argument).size() > 0 && Enum.class.isAssignableFrom(((List)argument).get(0).getClass())) {
            ArrayList<String> newList = new ArrayList<String>();
            for (Object listMember : (List)argument) {
                newList.add(((Enum)listMember).name());
            }
            return newList;
        }
        return argument;
    }
}

