/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import java.util.HashMap;
import java.util.Map;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateObject;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateObjectHelper;
import org.iternine.jeppetto.enhance.Enhancer;
import org.iternine.jeppetto.enhance.NoOpEnhancer;
import org.iternine.jeppetto.enhance.VelocityEnhancer;

public class EnhancerHelper {
    private static final Map<Class, Enhancer> dirtyableDBObjectEnhancers = new HashMap<Class, Enhancer>();
    private static final Map<Class, Enhancer> updateObjectEnhancers = new HashMap<Class, Enhancer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Enhancer<T> getDirtyableDBObjectEnhancer(Class<T> baseClass) {
        if (dirtyableDBObjectEnhancers.containsKey(baseClass)) {
            return dirtyableDBObjectEnhancers.get(baseClass);
        }
        Map<Class, Enhancer> map = dirtyableDBObjectEnhancers;
        synchronized (map) {
            Object enhancer;
            if (dirtyableDBObjectEnhancers.get(baseClass) != null) {
                enhancer = dirtyableDBObjectEnhancers.get(baseClass);
            } else if (DirtyableDBObject.class.isAssignableFrom(baseClass)) {
                enhancer = new NoOpEnhancer(baseClass);
                dirtyableDBObjectEnhancers.put(baseClass, (Enhancer)enhancer);
            } else {
                enhancer = new VelocityEnhancer<T>(baseClass){

                    public boolean needsEnhancement(Object object) {
                        return object != null && !(object instanceof DirtyableDBObject);
                    }

                    protected String getTemplateLocation() {
                        return "org/iternine/jeppetto/dao/mongodb/enhance/dirtyableDBObject.vm";
                    }
                };
                dirtyableDBObjectEnhancers.put(baseClass, (Enhancer)enhancer);
            }
            return enhancer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Enhancer<T> getUpdateObjectEnhancer(Class<T> baseClass) {
        if (updateObjectEnhancers.containsKey(baseClass)) {
            return updateObjectEnhancers.get(baseClass);
        }
        Map<Class, Enhancer> map = updateObjectEnhancers;
        synchronized (map) {
            Object enhancer;
            if (updateObjectEnhancers.get(baseClass) != null) {
                enhancer = updateObjectEnhancers.get(baseClass);
            } else if (UpdateObject.class.isAssignableFrom(baseClass)) {
                enhancer = new NoOpEnhancer(baseClass);
                updateObjectEnhancers.put(baseClass, (Enhancer)enhancer);
            } else {
                HashMap<String, UpdateObjectHelper> contextItems = new HashMap<String, UpdateObjectHelper>();
                contextItems.put("updateObjectHelper", new UpdateObjectHelper());
                enhancer = new VelocityEnhancer<T>(baseClass, contextItems){

                    public boolean needsEnhancement(Object object) {
                        return object != null && !(object instanceof UpdateObject);
                    }

                    protected String getTemplateLocation() {
                        return "org/iternine/jeppetto/dao/mongodb/enhance/updateObject.vm";
                    }
                };
                updateObjectEnhancers.put(baseClass, (Enhancer)enhancer);
            }
            return enhancer;
        }
    }
}

