/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateObject;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateOperation;

public class UpdateList
implements List,
UpdateObject {
    private String prefix;
    private UpdateOperation operation;
    private DBObject updates;
    private boolean clear = false;

    public Object set(int index, Object element) {
        if (this.clear) {
            throw new JeppettoException("set() after clear() not supported");
        }
        this.verifyOperation(UpdateOperation.$set, BasicDBObject.class);
        return this.updates.put(this.prefix + index, DBObjectUtil.toDBObject(element));
    }

    @Override
    public boolean add(Object element) {
        this.verifyOperation(UpdateOperation.$pushAll, BasicDBList.class);
        ((BasicDBList)this.updates).add(DBObjectUtil.toDBObject(element));
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        this.verifyOperation(UpdateOperation.$pushAll, BasicDBList.class);
        for (Object element : collection) {
            ((BasicDBList)this.updates).add(DBObjectUtil.toDBObject(element));
        }
        return true;
    }

    @Override
    public boolean remove(Object element) {
        if (this.clear) {
            throw new JeppettoException("remove() after clear() not supported");
        }
        this.verifyOperation(UpdateOperation.$pullAll, BasicDBList.class);
        ((BasicDBList)this.updates).add(DBObjectUtil.toDBObject(element));
        return true;
    }

    @Override
    public boolean removeAll(Collection collection) {
        if (this.clear) {
            throw new JeppettoException("removeAll() after clear() not supported");
        }
        this.verifyOperation(UpdateOperation.$pullAll, BasicDBList.class);
        for (Object element : collection) {
            ((BasicDBList)this.updates).add(DBObjectUtil.toDBObject(element));
        }
        return true;
    }

    @Override
    public void clear() {
        this.clear = true;
        this.operation = null;
        this.updates = new BasicDBList();
    }

    public void add(int index, Object element) {
        throw new JeppettoException("Can't add() an item to an UpdateList at a specific index");
    }

    public boolean addAll(int index, Collection elements) {
        throw new JeppettoException("Can't addAll() items to an UpdateList at a specific index");
    }

    public Object remove(int index) {
        throw new JeppettoException("Can't remove() an item to an UpdateList at a specific index");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public int size() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean isEmpty() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean contains(Object o) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public Iterator iterator() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public Object[] toArray() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public Object[] toArray(Object[] objects) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean containsAll(Collection objects) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public Object get(int index) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public int indexOf(Object o) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public ListIterator listIterator() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public ListIterator listIterator(int index) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public List subList(int fromIndex, int toIndex) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public DBObject getUpdateClause() {
        if (this.clear) {
            return new BasicDBObject(UpdateOperation.$set.name(), (Object)new BasicDBObject(this.getNameFromPrefix(), (Object)this.updates));
        }
        if (this.operation == null) {
            return new BasicDBObject();
        }
        if (this.operation == UpdateOperation.$set) {
            return new BasicDBObject(this.operation.name(), (Object)this.updates);
        }
        return new BasicDBObject(this.operation.name(), (Object)new BasicDBObject(this.getNameFromPrefix(), (Object)this.updates));
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private void verifyOperation(UpdateOperation operation, Class<? extends DBObject> updatesClass) {
        if (this.operation == null) {
            this.operation = operation;
            try {
                this.updates = updatesClass.newInstance();
            }
            catch (Exception e) {
                throw new JeppettoException((Throwable)e);
            }
        } else if (this.operation != operation) {
            throw new JeppettoException("Can't switch operation type to '" + (Object)((Object)operation) + "'.  '" + (Object)((Object)this.operation) + "' is already in use.");
        }
    }

    private String getNameFromPrefix() {
        return this.prefix.substring(0, this.prefix.length() - 1);
    }
}

