/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateObject;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateOperation;

public class UpdateMap
implements Map,
UpdateObject {
    private String prefix;
    private UpdateOperation operation;
    private BasicDBObject updates = new BasicDBObject();
    private boolean clear = false;

    public Object put(Object key, Object value) {
        this.verifyOperation(UpdateOperation.$set);
        return this.updates.put(this.getKeyForUpdate(key), DBObjectUtil.toDBObject(value));
    }

    public void putAll(Map m) {
        this.verifyOperation(UpdateOperation.$set);
        Iterator i$ = m.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            this.updates.put(this.getKeyForUpdate(entry.getKey()), DBObjectUtil.toDBObject(entry.getValue()));
        }
    }

    public Object remove(Object key) {
        if (this.clear) {
            throw new JeppettoException("remove() after clear() not supported");
        }
        this.verifyOperation(UpdateOperation.$unset);
        return this.updates.put(this.prefix + key, (Object)1);
    }

    @Override
    public void clear() {
        this.clear = true;
        this.operation = null;
        this.updates.clear();
    }

    @Override
    public int size() {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    @Override
    public boolean isEmpty() {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    public Object get(Object key) {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    public Set keySet() {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    public Collection values() {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    public Set entrySet() {
        throw new JeppettoException("An UpdateMap does not support query operations.");
    }

    @Override
    public DBObject getUpdateClause() {
        if (this.clear) {
            return new BasicDBObject(UpdateOperation.$set.name(), (Object)new BasicDBObject(this.getNameFromPrefix(), (Object)this.updates));
        }
        if (this.operation == null) {
            return new BasicDBObject();
        }
        return new BasicDBObject(this.operation.name(), (Object)this.updates);
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private void verifyOperation(UpdateOperation operation) {
        if (this.operation == null) {
            this.operation = operation;
        } else if (this.operation != operation) {
            throw new JeppettoException("Can't switch operation type to '" + (Object)((Object)operation) + "'.  '" + (Object)((Object)this.operation) + "' is already in use.");
        }
    }

    private String getKeyForUpdate(Object key) {
        return this.clear ? (String)key : this.prefix + key;
    }

    private String getNameFromPrefix() {
        return this.prefix.substring(0, this.prefix.length() - 1);
    }
}

