/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateObject;
import org.iternine.jeppetto.dao.mongodb.enhance.UpdateOperation;

public class UpdateSet
implements Set,
UpdateObject {
    private static final String EACH = "$each";
    private String prefix;
    private UpdateOperation operation;
    private Set<Object> updates = new HashSet<Object>();
    private boolean clear = false;

    @Override
    public boolean add(Object element) {
        this.verifyOperation(UpdateOperation.$addToSet);
        this.updates.add(DBObjectUtil.toDBObject(element));
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        this.verifyOperation(UpdateOperation.$addToSet);
        for (Object element : collection) {
            this.updates.add(DBObjectUtil.toDBObject(element));
        }
        return true;
    }

    @Override
    public boolean remove(Object element) {
        if (this.clear) {
            throw new JeppettoException("remove() after clear() not supported");
        }
        this.verifyOperation(UpdateOperation.$pullAll);
        this.updates.add(DBObjectUtil.toDBObject(element));
        return true;
    }

    @Override
    public boolean removeAll(Collection collection) {
        if (this.clear) {
            throw new JeppettoException("removeAll() after clear() not supported");
        }
        this.verifyOperation(UpdateOperation.$pullAll);
        for (Object element : collection) {
            this.updates.add(DBObjectUtil.toDBObject(element));
        }
        return true;
    }

    @Override
    public void clear() {
        this.clear = true;
        this.operation = null;
        this.updates.clear();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public int size() {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public boolean isEmpty() {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public boolean contains(Object o) {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public Iterator iterator() {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public Object[] toArray() {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public Object[] toArray(Object[] objects) {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public boolean containsAll(Collection objects) {
        throw new JeppettoException("An UpdateSet does not support query operations.");
    }

    @Override
    public DBObject getUpdateClause() {
        if (this.clear) {
            BasicDBList updateList = new BasicDBList();
            updateList.addAll(this.updates);
            return new BasicDBObject(UpdateOperation.$set.name(), (Object)new BasicDBObject(this.getNameFromPrefix(), (Object)updateList));
        }
        if (this.updates.isEmpty()) {
            return new BasicDBObject();
        }
        BasicDBList updateList = new BasicDBList();
        updateList.addAll(this.updates);
        if (this.operation.equals((Object)UpdateOperation.$addToSet)) {
            return new BasicDBObject(UpdateOperation.$addToSet.name(), (Object)new BasicDBObject(this.getNameFromPrefix(), (Object)new BasicDBObject(EACH, (Object)updateList)));
        }
        return new BasicDBObject(this.operation.name(), (Object)new BasicDBObject(this.getNameFromPrefix(), (Object)updateList));
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private void verifyOperation(UpdateOperation operation) {
        if (this.operation == null) {
            this.operation = operation;
        } else if (this.operation != operation) {
            throw new JeppettoException("Can't switch operation type to '" + (Object)((Object)operation) + "'.  '" + (Object)((Object)this.operation) + "' is already in use.");
        }
    }

    private String getNameFromPrefix() {
        return this.prefix.substring(0, this.prefix.length() - 1);
    }
}

