/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.projections;

import com.mongodb.DBObject;
import org.iternine.jeppetto.dao.mongodb.projections.MapReduceCommand;

class MinimumMapReduceCommand
extends MapReduceCommand {
    private String field;

    public MinimumMapReduceCommand(DBObject query, String field) {
        super(query);
        this.field = field;
    }

    @Override
    protected Object defaultValue() {
        return null;
    }

    @Override
    protected String createMapFunction() {
        return String.format("function() { emit( 1, this.%1$s ); }", this.field);
    }

    @Override
    protected String createReduceFunction() {
        return "function(k,v) { var min; for(var i in v) {     if (i == 0 || v[i] < min) {         min = v[i];     } } return min; }";
    }

    @Override
    protected Object transformToValue(DBObject dbObject) {
        return dbObject.get("value");
    }
}

