/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.enhance;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBCallback;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.Transformer;
import org.iternine.jeppetto.dao.mongodb.enhance.DBObjectUtil;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectList;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectMap;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObjectSet;
import org.iternine.jeppetto.dao.mongodb.enhance.EnhancerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBCallback
extends DefaultDBCallback {
    private static final Map<String, Class> classCache = new HashMap<String, Class>();
    private Class rootClass;
    private static Logger logger = LoggerFactory.getLogger(MongoDBCallback.class);
    private static final List<String> EXPLAIN_PATHS_TO_IGNORE = Arrays.asList("allPlans", "indexBounds", "shards", "oldPlan");

    public MongoDBCallback(DBCollection dbCollection, Class rootClass) {
        super(dbCollection);
        if (dbCollection != null && !dbCollection.getName().equals("$cmd")) {
            this.rootClass = rootClass;
        }
    }

    public BSONObject create(boolean array, List<String> pathParts) {
        if (this.rootClass == null) {
            return array ? new BasicDBList() : new BasicDBObject();
        }
        if (pathParts == null) {
            try {
                return (DBObject)this.rootClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String path = this.buildPath(pathParts);
        Class returnClass = this.getClassFromCache(path);
        if (returnClass == null) {
            returnClass = this.deriveClass(path, pathParts.get(pathParts.size() - 1), array);
        }
        if (DBObject.class.isAssignableFrom(returnClass)) {
            try {
                return (DBObject)returnClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (Map.class.isAssignableFrom(returnClass)) {
            if (Modifier.isAbstract(returnClass.getModifiers()) || Modifier.isInterface(returnClass.getModifiers())) {
                return new DirtyableDBObjectMap();
            }
            try {
                return new DirtyableDBObjectMap((Map)returnClass.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (List.class.isAssignableFrom(returnClass)) {
            if (Modifier.isAbstract(returnClass.getModifiers()) || Modifier.isInterface(returnClass.getModifiers())) {
                return new DirtyableDBObjectList();
            }
            try {
                return new DirtyableDBObjectList((List)returnClass.newInstance(), false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (Set.class.isAssignableFrom(returnClass)) {
            DirtyableDBObjectSet dirtyableDBObjectSet;
            if (Modifier.isAbstract(returnClass.getModifiers()) || Modifier.isInterface(returnClass.getModifiers())) {
                dirtyableDBObjectSet = new DirtyableDBObjectSet();
            } else {
                try {
                    dirtyableDBObjectSet = new DirtyableDBObjectSet((Set)returnClass.newInstance(), false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            BSON.addDecodingHook(DirtyableDBObjectSet.class, (Transformer)dirtyableDBObjectSet.getDecodingTransformer());
            return dirtyableDBObjectSet;
        }
        return new BasicDBObject();
    }

    private String buildPath(List<String> path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(path.get(i));
        }
        return sb.toString();
    }

    private Class getClassFromCache(String path) {
        Class clazz = classCache.get(this.rootClass.getSimpleName() + "." + path);
        if (clazz != null) {
            return clazz;
        }
        int lastDotIndex = path.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return classCache.get(this.rootClass.getSimpleName() + "." + path.substring(0, lastDotIndex + 1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class deriveClass(String path, String lastPathPart, boolean array) {
        Map<String, Class> map = classCache;
        synchronized (map) {
            Class cachedClass = this.getClassFromCache(path);
            if (cachedClass != null) {
                return cachedClass;
            }
            return this.deriveClass1(path, lastPathPart, array);
        }
    }

    private Class deriveClass1(String path, String lastPathPart, boolean array) {
        Method getter;
        Class containerClass = path.equals(lastPathPart) ? this.rootClass : classCache.get(this.rootClass.getSimpleName() + "." + path.substring(0, path.lastIndexOf(46)));
        if (containerClass != null && DBObject.class.isAssignableFrom(containerClass)) {
            try {
                Method m = containerClass.getMethod("__getPreEnhancedClass", new Class[0]);
                containerClass = (Class)m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                logger.warn("DBObject without __getPreEnhancedClass() method.  Was the container class enhanced?");
            }
        }
        if (containerClass == null) {
            return array ? BasicDBList.class : BasicDBObject.class;
        }
        try {
            getter = containerClass.getMethod("get" + Character.toUpperCase(lastPathPart.charAt(0)) + lastPathPart.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (!EXPLAIN_PATHS_TO_IGNORE.contains(lastPathPart) && !lastPathPart.startsWith("__")) {
                logger.warn("No getter for: {} ({})", (Object)lastPathPart, (Object)e.getMessage());
            }
            return array ? BasicDBList.class : BasicDBObject.class;
        }
        Type returnType = getter.getGenericReturnType();
        String qualifiedPath = this.rootClass.getSimpleName() + "." + path;
        if (Class.class.isAssignableFrom(returnType.getClass())) {
            Class enhancedClass = EnhancerHelper.getDirtyableDBObjectEnhancer((Class)returnType).getEnhancedClass();
            classCache.put(qualifiedPath, enhancedClass);
            return enhancedClass;
        }
        if (ParameterizedType.class.isAssignableFrom(returnType.getClass())) {
            Class rawClass;
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Map.class.isAssignableFrom(rawType)) {
                rawClass = (Class)parameterizedType.getActualTypeArguments()[1];
            } else if (Iterable.class.isAssignableFrom(rawType)) {
                rawClass = (Class)parameterizedType.getActualTypeArguments()[0];
            } else {
                throw new RuntimeException("unknown type: " + rawType);
            }
            classCache.put(qualifiedPath, rawType);
            if (!DBObjectUtil.needsNoConversion(rawClass)) {
                Class enhancedClass = EnhancerHelper.getDirtyableDBObjectEnhancer(rawClass).getEnhancedClass();
                classCache.put(qualifiedPath + ".", enhancedClass);
            }
            return rawType;
        }
        throw new RuntimeException("Don't know how to handle: " + qualifiedPath);
    }
}

