/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb.projections;

import com.mongodb.DBObject;
import java.math.BigDecimal;
import org.iternine.jeppetto.dao.mongodb.projections.MapReduceCommand;

class AverageMapReduceCommand
extends MapReduceCommand {
    private String field;

    public AverageMapReduceCommand(DBObject query, String field) {
        super(query);
        this.field = field;
    }

    @Override
    protected Object defaultValue() {
        return 0.0;
    }

    @Override
    protected String createMapFunction() {
        return String.format("function() { emit( 1, { total : this.%1$s , num : 1 } ); }", this.field);
    }

    @Override
    protected String createReduceFunction() {
        return "function(k,v) { var n = { total : 0, num : 0 };var count=0; var sum=0; for(var i in v) {     n.total += v[i].total;    n.num += v[i].num;} return n; }";
    }

    @Override
    protected Double transformToValue(DBObject dbObject) {
        DBObject valueObject = (DBObject)dbObject.get("value");
        Number total = (Number)valueObject.get("total");
        Number number = (Number)valueObject.get("num");
        if (number.intValue() == 0) {
            return 0.0;
        }
        return BigDecimal.valueOf(total.doubleValue()).divide(BigDecimal.valueOf(number.doubleValue())).doubleValue();
    }
}

