/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.mongodb;

import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.iternine.jeppetto.dao.mongodb.MongoDBQueryModelDAO;
import org.iternine.jeppetto.dao.mongodb.MongoDBSessionCache;
import org.iternine.jeppetto.dao.mongodb.enhance.DirtyableDBObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MongoDBSession {
    private final Map<String, MongoDBSessionCache> caches = new HashMap<String, MongoDBSessionCache>();
    private final Map<MongoDBQueryModelDAO<?, ?>, Map<DBObject, Object>> savedPerDAO = new HashMap();
    private final Map<MongoDBQueryModelDAO<?, ?>, Collection<DBObject>> deletedPerDAO = new HashMap();
    private final Deque<SessionEntryPoint> creators = new ArrayDeque<SessionEntryPoint>();
    private static final ThreadLocal<MongoDBSession> LOCAL = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(MongoDBSession.class);

    MongoDBSession() {
    }

    static boolean isActive() {
        return LOCAL.get() != null;
    }

    static void create() {
        MongoDBSession.create(logger, "Unknown Context");
    }

    static void create(Logger contextLogger, String contextName) {
        if (!MongoDBSession.isActive()) {
            logger.debug("Creating new MongoDBSession.");
            LOCAL.set(new MongoDBSession());
        }
        LOCAL.get().enter(contextLogger, contextName);
    }

    static void remove() {
        if (MongoDBSession.isActive() && LOCAL.get().exit()) {
            LOCAL.remove();
        }
    }

    static <T, ID> void trackForSave(MongoDBQueryModelDAO<T, ID> mongoDBQueryModelDAO, DBObject identifier, T entity, DBObject ... cacheKeys) {
        MongoDBSession.validateState();
        MongoDBSession mongoDBSession = LOCAL.get();
        Map<DBObject, Object> savedEntities = mongoDBSession.savedPerDAO.get(mongoDBQueryModelDAO);
        Collection<DBObject> deletedIdentifiers = mongoDBSession.deletedPerDAO.get(mongoDBQueryModelDAO);
        if (savedEntities == null) {
            savedEntities = new LinkedHashMap<DBObject, Object>();
            mongoDBSession.savedPerDAO.put(mongoDBQueryModelDAO, savedEntities);
        }
        if (deletedIdentifiers != null && deletedIdentifiers.contains(identifier)) {
            logger.debug("Item identified by {} has already been marked for delete, discarding.", (Object)identifier);
            return;
        }
        logger.debug("Tracking for save: {} = {}", (Object)identifier, entity);
        savedEntities.put(identifier, entity);
        MongoDBSessionCache sessionCache = MongoDBSession.getCache(mongoDBQueryModelDAO.getDbCollection().getName());
        for (DBObject cacheKey : cacheKeys) {
            sessionCache.put(cacheKey, entity);
        }
    }

    static void trackForDelete(MongoDBQueryModelDAO<?, ?> mongoDBQueryModelDAO, DBObject identifier) {
        MongoDBSession.validateState();
        MongoDBSession mongoDBSession = LOCAL.get();
        Collection<DBObject> deletedEntityIdentifiers = mongoDBSession.deletedPerDAO.get(mongoDBQueryModelDAO);
        if (logger.isDebugEnabled()) {
            if (deletedEntityIdentifiers.contains(identifier)) {
                logger.debug("Object already tracked for delete: {}", (Object)identifier);
            } else {
                logger.debug("Tracking for delete: {}", (Object)identifier);
            }
        }
        deletedEntityIdentifiers.add(identifier);
        if (mongoDBSession.savedPerDAO.get(mongoDBQueryModelDAO) != null) {
            mongoDBSession.savedPerDAO.get(mongoDBQueryModelDAO).remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void flush() {
        MongoDBSession.validateState();
        MongoDBSession mongoDBSession = LOCAL.get();
        if (mongoDBSession.creators.size() > 1) {
            return;
        }
        try {
            HashSet daoSet = new HashSet();
            daoSet.addAll(mongoDBSession.savedPerDAO.keySet());
            daoSet.addAll(mongoDBSession.deletedPerDAO.keySet());
            for (MongoDBQueryModelDAO mongoDBQueryModelDAO : daoSet) {
                mongoDBSession.doFlush(mongoDBQueryModelDAO);
            }
        }
        finally {
            mongoDBSession.clear();
        }
    }

    static void flush(MongoDBQueryModelDAO<?, ?> mongoDBQueryModelDAO) {
        MongoDBSession.validateState();
        LOCAL.get().doFlush(mongoDBQueryModelDAO);
    }

    static Object getObjectFromCache(String type, DBObject query) {
        return MongoDBSession.getCache(type).get(query);
    }

    private static void validateState() {
        if (!MongoDBSession.isActive()) {
            throw new IllegalStateException("Session not active.");
        }
    }

    private static MongoDBSessionCache getCache(String type) {
        MongoDBSession.validateState();
        MongoDBSession mongoDBSession = LOCAL.get();
        MongoDBSessionCache sessionCache = mongoDBSession.caches.get(type);
        if (sessionCache != null) {
            return sessionCache;
        }
        mongoDBSession.caches.put(type, new MongoDBSessionCache());
        return mongoDBSession.caches.get(type);
    }

    private void enter(Logger logger, String name) {
        int offset = 3;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement creator = stackTrace[Math.min(offset, stackTrace.length - 1)];
        this.creators.push(new SessionEntryPoint(creator, logger, name));
    }

    private boolean exit() {
        boolean last = this.creators.size() == 1;
        try {
            if (!last) {
                Iterator<Collection<DBObject>> context = this.creators.peek().getName();
                logger.debug("Leaving re-entrant session created by {}", (Object)context);
            }
            this.creators.pop();
            if (last) {
                logger.debug("Removing MongoDBSession");
                if (logger.isDebugEnabled()) {
                    for (Map.Entry entry : this.savedPerDAO.entrySet()) {
                        for (Object entity : ((Map)entry.getValue()).values()) {
                            if (!(entity instanceof DirtyableDBObject) || !((DirtyableDBObject)entity).isDirty()) continue;
                            logger.warn("{} is still dirty: {}", ((MongoDBQueryModelDAO)entry.getKey()).getClass(), entity);
                        }
                    }
                    for (Collection<DBObject> collection : this.deletedPerDAO.values()) {
                        for (DBObject deletedEntityIdentifier : collection) {
                            logger.debug("Removing {} before delete due to session close.", (Object)deletedEntityIdentifier);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            try {
                logger.error("Error while removing session.", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return last;
    }

    private void clear() {
        this.savedPerDAO.clear();
        this.caches.clear();
        this.deletedPerDAO.clear();
    }

    private void doFlush(MongoDBQueryModelDAO<?, ?> mongoDBQueryModelDAO) {
        String contextName = this.creators.peek().getName();
        Logger contextLogger = this.creators.peek().getLogger();
        long dirtyCheckCost = 0L;
        int saveCount = 0;
        int deleteCount = 0;
        if (this.savedPerDAO.containsKey(mongoDBQueryModelDAO)) {
            Map<DBObject, Object> savedEntities = this.savedPerDAO.get(mongoDBQueryModelDAO);
            for (Map.Entry<DBObject, Object> entry : savedEntities.entrySet()) {
                try {
                    DirtyableDBObject enhancedEntity = (DirtyableDBObject)entry.getValue();
                    long beforeDirtyCheck = System.nanoTime();
                    boolean isDirty = enhancedEntity.isDirty();
                    dirtyCheckCost += System.nanoTime() - beforeDirtyCheck;
                    if (!isDirty) continue;
                    mongoDBQueryModelDAO.trueSave(entry.getKey(), enhancedEntity);
                    ++saveCount;
                }
                catch (MongoException.DuplicateKey e) {
                    logger.warn("Error saving {}. Duplicate record found.", entry.getValue());
                }
                catch (MongoException e) {
                    logger.error("Error saving {}.", entry.getValue(), (Object)e);
                }
            }
            savedEntities.clear();
        }
        if (this.deletedPerDAO.containsKey(mongoDBQueryModelDAO)) {
            Collection<DBObject> deletedEntityIdentifiers = this.deletedPerDAO.get(mongoDBQueryModelDAO);
            for (DBObject deletedEntityIdentifier : deletedEntityIdentifiers) {
                try {
                    mongoDBQueryModelDAO.trueRemove(deletedEntityIdentifier);
                    ++deleteCount;
                }
                catch (MongoException e) {
                    logger.error("Error removing {}.", (Object)deletedEntityIdentifier, (Object)e);
                }
            }
            deletedEntityIdentifiers.clear();
        }
        MongoDBSession.getCache(mongoDBQueryModelDAO.getDbCollection().getName()).clear();
        contextLogger.debug("{} flushed {}s in {}ms. (save={}, delete={})", new Object[]{contextName, mongoDBQueryModelDAO.getCollectionClass().getSimpleName(), TimeUnit.NANOSECONDS.toMillis(dirtyCheckCost), saveCount, deleteCount});
    }

    private static final class SessionEntryPoint {
        private StackTraceElement stackTraceElement;
        private Logger logger;
        private String name;

        public SessionEntryPoint(StackTraceElement stackTraceElement, Logger logger, String name) {
            this.stackTraceElement = stackTraceElement;
            this.logger = logger;
            this.name = name;
        }

        public StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public String getName() {
            return this.name;
        }
    }
}

