/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.AccessControllable;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.GenericDAO;
import org.iternine.jeppetto.dao.QueryModelDAO;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.annotation.Condition;
import org.iternine.jeppetto.dao.annotation.DataAccessMethod;
import org.iternine.jeppetto.enhance.ClassLoadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOBuilder {
    private static final AtomicInteger count = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(DAOBuilder.class);

    public static <T, ID, I extends GenericDAO<T, ID>> I buildDAO(Class<T> modelClass, Class<I> daoInterface, Class<? extends QueryModelDAO<T, ID>> partialDAOClass, Map<String, Object> daoProperties) {
        return DAOBuilder.buildDAO(modelClass, daoInterface, partialDAOClass, daoProperties, null);
    }

    public static <T, ID, I extends GenericDAO<T, ID>> I buildDAO(Class<T> modelClass, Class<I> daoInterface, Class<? extends QueryModelDAO<T, ID>> partialDAOClass, Map<String, Object> daoProperties, AccessControlContextProvider accessControlContextProvider) {
        if (AccessControllable.class.isAssignableFrom(daoInterface)) {
            if (!AccessControllable.class.isAssignableFrom(partialDAOClass)) {
                throw new RuntimeException("Concrete DAO doesn't support AccessControllable (which is expected by DAO interface)");
            }
            try {
                partialDAOClass.getDeclaredConstructor(Class.class, Map.class, AccessControlContextProvider.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Concrete DAO doesn't support AccessControllable (which is expected by DAO interface)");
            }
            if (accessControlContextProvider == null) {
                throw new RuntimeException("No AccessControlContextProvider specified.");
            }
        }
        Class<I> fullDAOClass = DAOBuilder.completeDAO(modelClass, daoInterface, partialDAOClass, accessControlContextProvider != null);
        try {
            if (accessControlContextProvider != null) {
                return (I)((GenericDAO)fullDAOClass.getDeclaredConstructor(Class.class, Map.class, AccessControlContextProvider.class).newInstance(modelClass, daoProperties, accessControlContextProvider));
            }
            return (I)((GenericDAO)fullDAOClass.getDeclaredConstructor(Class.class, Map.class).newInstance(modelClass, daoProperties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T, ID, I extends GenericDAO<T, ID>> Class<? extends I> completeDAO(Class<T> modelClass, Class<I> daoInterface, Class<? extends QueryModelDAO<T, ID>> partialDAOClass, boolean accessControlEnabled) {
        try {
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath((ClassPath)new ClassClassPath(daoInterface));
            CtClass daoInterfaceCtClass = pool.get(daoInterface.getName());
            CtClass partialDAOCtClass = pool.get(partialDAOClass.getName());
            CtClass concrete = pool.makeClass(String.format("%s$%d", daoInterface.getName(), count.incrementAndGet()));
            concrete.setSuperclass(partialDAOCtClass);
            concrete.addInterface(daoInterfaceCtClass);
            String constructorCode = accessControlEnabled ? String.format("public %s(Class entityClass, java.util.Map daoProperties, org.iternine.jeppetto.dao.AccessControlContextProvider accessControlContextProvider) {     super(entityClass, daoProperties, accessControlContextProvider); }", concrete.getSimpleName()) : String.format("public %s(Class entityClass, java.util.Map daoProperties) {     super(entityClass, daoProperties); }", concrete.getSimpleName());
            concrete.addConstructor(CtNewConstructor.make((String)constructorCode, (CtClass)concrete));
            for (CtMethod interfaceMethod : daoInterfaceCtClass.getMethods()) {
                try {
                    CtMethod daoMethod = partialDAOCtClass.getMethod(interfaceMethod.getName(), interfaceMethod.getSignature());
                    if (!Modifier.isAbstract(daoMethod.getModifiers())) {
                        continue;
                    }
                }
                catch (NotFoundException ignore) {
                    // empty catch block
                }
                DAOBuilder.implementMethod(concrete, interfaceMethod, modelClass, accessControlEnabled);
            }
            return ClassLoadingUtil.toClass((CtClass)concrete);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> void implementMethod(CtClass concrete, CtMethod interfaceMethod, Class<T> modelClass, boolean accessControlEnabled) throws CannotCompileException, ClassNotFoundException {
        CtMethod concreteMethod = CtNewMethod.copy((CtMethod)interfaceMethod, (CtClass)concrete, null);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n    java.util.Iterator argsIterator = java.util.Arrays.asList($args).iterator();\n    org.iternine.jeppetto.dao.QueryModel queryModel = new org.iternine.jeppetto.dao.QueryModel();\n\n");
        DataAccessMethod dataAccessMethod = (DataAccessMethod)interfaceMethod.getAnnotation(DataAccessMethod.class);
        if (dataAccessMethod != null) {
            DAOBuilder.buildQueryModelFromAnnotation(dataAccessMethod, sb);
            if (accessControlEnabled) {
                if (dataAccessMethod.useAccessControlContextArgument()) {
                    sb.append("    queryModel.setAccessControlContext((org.iternine.jeppetto.dao.AccessControlContext) argsIterator.next());\n\n");
                } else if (!dataAccessMethod.invokeWithRole().isEmpty()) {
                    sb.append("    org.iternine.jeppetto.dao.SimpleAccessControlContext accessControlContext = new org.iternine.jeppetto.dao.SimpleAccessControlContext();\n");
                    sb.append("    accessControlContext.setRole(\"").append(dataAccessMethod.invokeWithRole()).append("\");\n");
                    sb.append("    queryModel.setAccessControlContext(accessControlContext);\n\n");
                } else {
                    sb.append("    queryModel.setAccessControlContext(getAccessControlContextProvider().getCurrent());\n\n");
                }
            }
        } else {
            DAOBuilder.buildQueryModelFromMethodName(interfaceMethod.getName(), sb);
            if (accessControlEnabled) {
                if (interfaceMethod.getName().endsWith("As")) {
                    sb.append("    queryModel.setAccessControlContext((org.iternine.jeppetto.dao.AccessControlContext) argsIterator.next());\n\n");
                } else {
                    sb.append("    queryModel.setAccessControlContext(getAccessControlContextProvider().getCurrent());\n\n");
                }
            }
        }
        DAOBuilder.buildReturnClause(interfaceMethod, sb, modelClass);
        sb.append('\n').append('}');
        if (logger.isDebugEnabled()) {
            DAOBuilder.logDerivedMethod(interfaceMethod, sb);
        }
        try {
            concreteMethod.setBody(sb.toString());
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Unable to add method:\n" + sb.toString(), e);
        }
        concrete.addMethod(concreteMethod);
    }

    private static void buildQueryModelFromAnnotation(DataAccessMethod dataAccessMethod, StringBuilder sb) {
        if (dataAccessMethod.conditions() != null && dataAccessMethod.conditions().length > 0) {
            for (Annotation annotation : dataAccessMethod.conditions()) {
                sb.append(String.format("    queryModel.addCondition(buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", annotation.field(), annotation.type().name()));
            }
            sb.append('\n');
        }
        if (dataAccessMethod.associations() != null && dataAccessMethod.associations().length > 0) {
            for (Annotation annotation : dataAccessMethod.associations()) {
                for (Condition conditionAnnotation : annotation.conditions()) {
                    sb.append(String.format("    queryModel.addAssociationCondition(\"%s\", buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", annotation.field(), conditionAnnotation.field(), conditionAnnotation.type().name()));
                }
            }
            sb.append('\n');
        }
        if (dataAccessMethod.projections() != null && dataAccessMethod.projections().length > 0) {
            sb.append(String.format("    queryModel.setProjection(buildProjection(\"%s\", org.iternine.jeppetto.dao.ProjectionType.%s, argsIterator));\n\n", dataAccessMethod.projections()[0].field(), dataAccessMethod.projections()[0].type().name()));
        }
        if (dataAccessMethod.sorts() != null && dataAccessMethod.sorts().length > 0) {
            for (Annotation annotation : dataAccessMethod.sorts()) {
                sb.append(String.format("    queryModel.addSort(org.iternine.jeppetto.dao.SortDirection.%s, \"%s\");\n", annotation.direction().name(), annotation.field()));
            }
            sb.append('\n');
        }
        if (dataAccessMethod.limitResults()) {
            sb.append("    queryModel.setMaxResults(((Integer) argsIterator.next()).intValue());\n\n");
        }
        if (dataAccessMethod.skipResults()) {
            sb.append("    queryModel.setFirstResult(((Integer) argsIterator.next()).intValue());\n\n");
        }
    }

    private static void buildQueryModelFromMethodName(String methodName, StringBuilder sb) {
        String orderParts;
        String[] queryParts;
        String queryString;
        if (methodName.startsWith("findBy")) {
            queryString = methodName.substring("findBy".length());
        } else if (methodName.startsWith("countBy")) {
            sb.append("    queryModel.setProjection(buildProjection(null, org.iternine.jeppetto.dao.ProjectionType.RowCount, argsIterator));\n\n");
            queryString = methodName.substring("countBy".length());
        } else {
            throw new UnsupportedOperationException("Don't know how to handle '" + methodName + "'");
        }
        int orderByIndex = queryString.indexOf("OrderBy");
        if (orderByIndex == -1) {
            queryParts = queryString.split("Having");
            orderParts = null;
        } else {
            queryParts = queryString.substring(0, orderByIndex).split("Having");
            orderParts = queryString.substring(orderByIndex + "OrderBy".length(), queryString.length());
        }
        if (queryParts != null) {
            if (queryParts[0].length() > 0) {
                String[] conditionStrings;
                for (String conditionString : conditionStrings = queryParts[0].split("And")) {
                    String conditionName = DAOBuilder.getConditionNameFromString(conditionString);
                    sb.append(String.format("    queryModel.addCondition(buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", DAOBuilder.pruneFieldNameFromString(conditionString, conditionName), conditionName));
                }
                sb.append('\n');
            }
            for (int i = 1; i < queryParts.length; ++i) {
                String[] conditionStrings;
                String associationString = queryParts[i];
                int withIndex = associationString.indexOf("With");
                for (String conditionString : conditionStrings = associationString.substring(withIndex + 4, associationString.length()).split("And")) {
                    String conditionName = DAOBuilder.getConditionNameFromString(conditionString);
                    sb.append(String.format("    queryModel.addAssociationCondition(\"%s\", buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", Character.toLowerCase(associationString.charAt(0)) + associationString.substring(1, withIndex), DAOBuilder.pruneFieldNameFromString(conditionString, conditionName), conditionName));
                }
                sb.append('\n');
            }
        }
        if (orderParts != null) {
            for (String orderPart : orderParts.split("And")) {
                String fieldName;
                SortDirection sortDirection;
                if (orderPart.endsWith("Desc")) {
                    sortDirection = SortDirection.Descending;
                    fieldName = DAOBuilder.pruneFieldNameFromString(orderPart, "Desc");
                } else {
                    sortDirection = SortDirection.Ascending;
                    fieldName = DAOBuilder.pruneFieldNameFromString(orderPart, "Asc");
                }
                sb.append(String.format("    queryModel.addSort(org.iternine.jeppetto.dao.SortDirection.%s, \"%s\");\n", sortDirection.name(), fieldName));
            }
            sb.append('\n');
        }
    }

    private static String getConditionNameFromString(String conditionString) {
        for (ConditionType conditionType : ConditionType.values()) {
            if (!conditionString.endsWith(conditionType.name())) continue;
            return conditionType.name();
        }
        return ConditionType.Equal.name();
    }

    private static String pruneFieldNameFromString(String conditionString, String trailingPart) {
        StringBuilder fieldName = new StringBuilder();
        if (conditionString.endsWith(trailingPart)) {
            fieldName.append(conditionString.substring(0, conditionString.length() - trailingPart.length()));
        } else {
            fieldName.append(conditionString);
        }
        fieldName.setCharAt(0, Character.toLowerCase(conditionString.charAt(0)));
        return fieldName.toString();
    }

    private static <T> void buildReturnClause(CtMethod method, StringBuilder sb, Class<T> modelClass) {
        try {
            String returnTypeName = method.getReturnType().getName();
            if (modelClass.getName().equals(returnTypeName)) {
                if (method.getExceptionTypes().length > 0) {
                    sb.append("\n    return ($r) findUniqueUsingQueryModel(queryModel);");
                } else {
                    sb.append("    try {\n        return ($r) findUniqueUsingQueryModel(queryModel);\n    } catch (org.iternine.jeppetto.dao.NoSuchItemException e) {\n        return null;\n    }");
                }
            } else if ("java.util.Set".equals(returnTypeName)) {
                sb.append("    java.util.Set result = new java.util.HashSet();\n    for (java.util.Iterator iterator = findUsingQueryModel(queryModel).iterator(); iterator.hasNext(); ) {\n        result.add(iterator.next());\n    }\n     \n    return result;");
            } else if ("java.util.List".equals(returnTypeName) || "java.util.Collection".equals(returnTypeName)) {
                sb.append("    java.util.List result = new java.util.ArrayList();\n    for (java.util.Iterator iterator = findUsingQueryModel(queryModel).iterator(); iterator.hasNext(); ) {\n        result.add(iterator.next());\n    }\n     \n    return result;");
            } else if ("java.lang.Iterable".equals(returnTypeName)) {
                sb.append("\n    return findUsingQueryModel(queryModel);");
            } else {
                sb.append("\n    return ($r) projectUsingQueryModel(queryModel);");
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void logDerivedMethod(CtMethod interfaceMethod, StringBuilder sb) {
        try {
            String parameters = "";
            String exceptions = "\n        throws ";
            int parameterCount = 0;
            for (CtClass parameterType : interfaceMethod.getParameterTypes()) {
                if (parameters.length() > 0) {
                    parameters = parameters + ", ";
                }
                parameters = parameters + parameterType.getSimpleName() + " a" + parameterCount++;
            }
            for (CtClass exceptionType : interfaceMethod.getExceptionTypes()) {
                exceptions = exceptions + exceptionType.getSimpleName();
            }
            logger.debug(String.format("Adding DAO method implementation: \n\npublic %s %s(%s) %s %s\n\n", interfaceMethod.getReturnType().getSimpleName(), interfaceMethod.getName(), parameters, exceptions.length() > 17 ? exceptions : "", sb.toString()));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

