/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.Sort;
import org.iternine.jeppetto.dao.SortDirection;

public class QueryModel {
    private List<Condition> conditions;
    private Map<String, List<Condition>> associationConditions = new LinkedHashMap<String, List<Condition>>();
    private List<Sort> sorts;
    private Projection projection;
    private int maxResults = -1;
    private int firstResult = -1;
    private AccessControlContext accessControlContext;

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(Condition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(condition);
    }

    public Map<String, List<Condition>> getAssociationConditions() {
        return this.associationConditions;
    }

    public void setAssociationConditions(Map<String, List<Condition>> associationConditions) {
        this.associationConditions = associationConditions;
    }

    public void addAssociationCondition(String associationField, Condition condition) {
        List<Condition> conditions = this.associationConditions.get(associationField);
        if (conditions == null) {
            conditions = new ArrayList<Condition>();
            this.associationConditions.put(associationField, conditions);
        }
        conditions.add(condition);
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<Sort> sorts) {
        this.sorts = sorts;
    }

    public void addSort(SortDirection sortDirection, String sortField) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<Sort>(1);
        }
        this.sorts.add(new Sort(sortField, sortDirection));
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    public void setAccessControlContext(AccessControlContext accessControlContext) {
        this.accessControlContext = accessControlContext;
    }
}

