/*
 * Copyright (c) 2011-2014 Jeppetto and Jonathan Thompson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.iternine.jeppetto.dao.annotation;


import org.iternine.jeppetto.dao.OperationType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface DataAccessMethod {

    public abstract OperationType operation() default OperationType.Read;

    public abstract Condition[] conditions() default {};

    public abstract Association[] associations() default {};

    public abstract Projection[] projections() default {};

    public abstract Sort[] sorts() default {};

    public abstract boolean limitResults() default false;

    public abstract boolean skipResults() default false;

    public abstract boolean useAccessControlContextArgument() default false;
}
