/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao;

public enum AccessType {
    None("N", new AllowsRule(){

        @Override
        public boolean allows(AccessType accessType) {
            return false;
        }
    }),
    Read("R", new AllowsRule(){

        @Override
        public boolean allows(AccessType accessType) {
            return Read.ordinal() >= accessType.ordinal();
        }
    }),
    ReadWrite("RW", new AllowsRule(){

        @Override
        public boolean allows(AccessType accessType) {
            return true;
        }
    });

    private String shortName;
    private AllowsRule allowsRule;

    private AccessType(String shortName, AllowsRule allowsRule) {
        this.shortName = shortName;
        this.allowsRule = allowsRule;
    }

    public static AccessType getAccessTypeFromShortName(String shortName) {
        if ("R".equals(shortName)) {
            return Read;
        }
        if ("RW".equals(shortName)) {
            return ReadWrite;
        }
        if ("N".equals(shortName)) {
            return None;
        }
        throw new RuntimeException("Unknown shortName: " + shortName);
    }

    public String shortName() {
        return this.shortName;
    }

    public boolean allows(AccessType accessType) {
        return this.allowsRule.allows(accessType);
    }

    private static interface AllowsRule {
        public boolean allows(AccessType var1);
    }
}

