/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao;

import com.yammer.metrics.core.TimerContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.iternine.jeppetto.dao.AccessControlContextProvider;
import org.iternine.jeppetto.dao.AccessControlDAO;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.GenericDAO;
import org.iternine.jeppetto.dao.OperationType;
import org.iternine.jeppetto.dao.QueryModelDAO;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.annotation.Condition;
import org.iternine.jeppetto.dao.annotation.DataAccessMethod;
import org.iternine.jeppetto.enhance.ClassLoadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOBuilder {
    private static final AtomicInteger count = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(DAOBuilder.class);

    public static <T, ID, I extends GenericDAO<T, ID>> I buildDAO(Class<T> modelClass, Class<I> daoInterface, Class<? extends QueryModelDAO<T, ID>> partialDAOClass, Map<String, Object> daoProperties) {
        return DAOBuilder.buildDAO(modelClass, daoInterface, partialDAOClass, daoProperties, null);
    }

    public static <T, ID, I extends GenericDAO<T, ID>> I buildDAO(Class<T> modelClass, Class<I> daoInterface, Class<? extends QueryModelDAO<T, ID>> partialDAOClass, Map<String, Object> daoProperties, AccessControlContextProvider accessControlContextProvider) {
        if (AccessControlDAO.class.isAssignableFrom(daoInterface)) {
            if (!AccessControlDAO.class.isAssignableFrom(partialDAOClass)) {
                throw new RuntimeException("Concrete DAO doesn't support AccessControlDAO (expected by the DAO interface)");
            }
            try {
                partialDAOClass.getDeclaredConstructor(Class.class, Map.class, AccessControlContextProvider.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Concrete DAO doesn't support AccessControlDAO (expected by the DAO interface)");
            }
            if (accessControlContextProvider == null) {
                throw new RuntimeException("No AccessControlContextProvider specified.");
            }
        }
        Class<I> fullDAOClass = DAOBuilder.completeDAO(modelClass, daoInterface, partialDAOClass, accessControlContextProvider != null, daoProperties != null && Boolean.parseBoolean((String)daoProperties.get("enableMetrics")));
        try {
            if (accessControlContextProvider != null) {
                Constructor<I> constructor = fullDAOClass.getDeclaredConstructor(Class.class, Map.class, AccessControlContextProvider.class);
                return (I)((GenericDAO)constructor.newInstance(modelClass, daoProperties, accessControlContextProvider));
            }
            Constructor<I> constructor = fullDAOClass.getDeclaredConstructor(Class.class, Map.class);
            return (I)((GenericDAO)constructor.newInstance(modelClass, daoProperties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T, ID, I extends GenericDAO<T, ID>> Class<? extends I> completeDAO(Class<T> modelClass, Class<I> daoInterface, Class<? extends QueryModelDAO<T, ID>> partialDAOClass, boolean accessControlEnabled, boolean metricsEnabled) {
        try {
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath((ClassPath)new ClassClassPath(daoInterface));
            CtClass fullDAOCtClass = pool.makeClass(String.format("%s$%d", daoInterface.getName(), count.incrementAndGet()));
            CtClass partialDAOCtClass = pool.get(partialDAOClass.getName());
            CtClass daoInterfaceCtClass = pool.get(daoInterface.getName());
            fullDAOCtClass.setSuperclass(partialDAOCtClass);
            fullDAOCtClass.addInterface(daoInterfaceCtClass);
            DAOBuilder.buildConstructor(fullDAOCtClass, accessControlEnabled);
            DAOBuilder.buildNeededMethods(fullDAOCtClass, partialDAOCtClass, daoInterfaceCtClass, modelClass, accessControlEnabled, metricsEnabled);
            return ClassLoadingUtil.toClass((CtClass)fullDAOCtClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void buildConstructor(CtClass fullDAOCtClass, boolean accessControlEnabled) throws CannotCompileException {
        String constructorCode = accessControlEnabled ? String.format("public %s(Class entityClass, java.util.Map daoProperties, org.iternine.jeppetto.dao.AccessControlContextProvider accessControlContextProvider) {     super(entityClass, daoProperties, accessControlContextProvider); }", fullDAOCtClass.getSimpleName()) : String.format("public %s(Class entityClass, java.util.Map daoProperties) {     super(entityClass, daoProperties); }", fullDAOCtClass.getSimpleName());
        fullDAOCtClass.addConstructor(CtNewConstructor.make((String)constructorCode, (CtClass)fullDAOCtClass));
    }

    private static <T> void buildNeededMethods(CtClass fullDAOCtClass, CtClass partialDAOCtClass, CtClass daoInterfaceCtClass, Class<T> modelClass, boolean accessControlEnabled, boolean metricsEnabled) throws CannotCompileException, ClassNotFoundException, NotFoundException {
        for (CtMethod interfaceMethod : daoInterfaceCtClass.getMethods()) {
            CtMethod daoMethod;
            try {
                daoMethod = partialDAOCtClass.getMethod(interfaceMethod.getName(), interfaceMethod.getSignature());
                if (!Modifier.isAbstract(daoMethod.getModifiers())) {
                    if (!metricsEnabled || !DAOBuilder.shouldAddMetricsToMethod(interfaceMethod, daoInterfaceCtClass)) continue;
                    logger.debug("Generating metrics delegate for method " + daoMethod.getName() + "()");
                    CtMethod delegator = CtNewMethod.delegator((CtMethod)daoMethod, (CtClass)fullDAOCtClass);
                    DAOBuilder.insertMetrics(fullDAOCtClass, delegator, daoInterfaceCtClass);
                    fullDAOCtClass.addMethod(delegator);
                    continue;
                }
            }
            catch (NotFoundException ignore) {
                // empty catch block
            }
            daoMethod = DAOBuilder.implementMethod(fullDAOCtClass, interfaceMethod, modelClass, accessControlEnabled);
            if (!metricsEnabled) continue;
            DAOBuilder.insertMetrics(fullDAOCtClass, daoMethod, daoInterfaceCtClass);
        }
    }

    private static boolean shouldAddMetricsToMethod(CtMethod interfaceMethod, CtClass daoInterfaceCtClass) {
        try {
            daoInterfaceCtClass.getDeclaredMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            return true;
        }
        catch (NotFoundException ignore) {
            try {
                ClassPool.getDefault().get(GenericDAO.class.getName()).getDeclaredMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
                return true;
            }
            catch (NotFoundException notFoundException) {
                return false;
            }
        }
    }

    private static void insertMetrics(CtClass fullDAOCtClass, CtMethod daoMethod, CtClass daoInterfaceCtClass) throws CannotCompileException, NotFoundException {
        String timerField = DAOBuilder.createTimerField(fullDAOCtClass, daoMethod, daoInterfaceCtClass);
        logger.debug("Adding metrics to method " + daoMethod.getName() + "()");
        daoMethod.addLocalVariable("__tc", ClassPool.getDefault().get(TimerContext.class.getName()));
        daoMethod.insertBefore("__tc = this." + timerField + ".time();");
        daoMethod.insertAfter("__tc.stop();", false);
    }

    private static String createTimerField(CtClass fullCtClass, CtMethod daoMethod, CtClass daoInterfaceCtClass) throws CannotCompileException {
        String timerField = "__" + daoMethod.getName() + "Timer";
        String timerDeclaration = "private final com.yammer.metrics.core.Timer " + timerField + "  = com.yammer.metrics.Metrics.newTimer(" + daoInterfaceCtClass.getName() + ".class, " + "\"" + daoMethod.getName() + "\");";
        logger.debug("Adding Timer field: " + timerField);
        fullCtClass.addField(CtField.make((String)timerDeclaration, (CtClass)fullCtClass));
        return timerField;
    }

    private static <T> CtMethod implementMethod(CtClass fullDAOCtClass, CtMethod interfaceMethod, Class<T> modelClass, boolean accessControlEnabled) throws CannotCompileException, ClassNotFoundException {
        OperationType operationType;
        CtMethod daoMethod = CtNewMethod.copy((CtMethod)interfaceMethod, (CtClass)fullDAOCtClass, null);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n    java.util.Iterator argsIterator = java.util.Arrays.asList($args).iterator();\n    org.iternine.jeppetto.dao.QueryModel queryModel = new org.iternine.jeppetto.dao.QueryModel();\n\n");
        DataAccessMethod dataAccessMethod = (DataAccessMethod)interfaceMethod.getAnnotation(DataAccessMethod.class);
        if (dataAccessMethod != null) {
            operationType = DAOBuilder.buildQueryModelFromAnnotation(dataAccessMethod, sb);
            if (accessControlEnabled) {
                if (dataAccessMethod.useAccessControlContextArgument()) {
                    sb.append("    queryModel.setAccessControlContext((org.iternine.jeppetto.dao.AccessControlContext) argsIterator.next());\n\n");
                } else {
                    sb.append("    queryModel.setAccessControlContext(getAccessControlContextProvider().getCurrent());\n\n");
                }
            }
        } else {
            operationType = DAOBuilder.buildQueryModelFromMethodName(interfaceMethod.getName(), sb);
            if (accessControlEnabled) {
                if (interfaceMethod.getName().endsWith("As")) {
                    sb.append("    queryModel.setAccessControlContext((org.iternine.jeppetto.dao.AccessControlContext) argsIterator.next());\n\n");
                } else {
                    sb.append("    queryModel.setAccessControlContext(getAccessControlContextProvider().getCurrent());\n\n");
                }
            }
        }
        switch (operationType) {
            case Read: {
                DAOBuilder.buildReturnClause(interfaceMethod, sb, modelClass);
                break;
            }
            case Update: {
                DAOBuilder.buildUpdateClause(sb);
                break;
            }
            case Delete: {
                DAOBuilder.buildDeleteClause(sb);
            }
        }
        sb.append('\n').append('}');
        if (logger.isDebugEnabled()) {
            DAOBuilder.logDerivedMethod(interfaceMethod, sb);
        }
        try {
            daoMethod.setBody(sb.toString());
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Unable to add method:\n" + sb.toString(), e);
        }
        fullDAOCtClass.addMethod(daoMethod);
        return daoMethod;
    }

    private static OperationType buildQueryModelFromAnnotation(DataAccessMethod dataAccessMethod, StringBuilder sb) {
        if (dataAccessMethod.operation() == OperationType.Update) {
            sb.append("    org.iternine.jeppetto.dao.updateobject.UpdateObject updateObject = (org.iternine.jeppetto.dao.updateobject.UpdateObject) argsIterator.next();\n\n");
        }
        if (dataAccessMethod.conditions() != null && dataAccessMethod.conditions().length > 0) {
            for (Annotation annotation : dataAccessMethod.conditions()) {
                sb.append(String.format("    queryModel.addCondition(buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", annotation.field(), annotation.type().name()));
            }
            sb.append('\n');
        }
        if (dataAccessMethod.associations() != null && dataAccessMethod.associations().length > 0) {
            for (Annotation annotation : dataAccessMethod.associations()) {
                for (Condition conditionAnnotation : annotation.conditions()) {
                    sb.append(String.format("    queryModel.addAssociationCondition(\"%s\", buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", annotation.field(), conditionAnnotation.field(), conditionAnnotation.type().name()));
                }
            }
            sb.append('\n');
        }
        if (dataAccessMethod.projections() != null && dataAccessMethod.projections().length > 0) {
            sb.append(String.format("    queryModel.setProjection(buildProjection(\"%s\", org.iternine.jeppetto.dao.ProjectionType.%s, argsIterator));\n\n", dataAccessMethod.projections()[0].field(), dataAccessMethod.projections()[0].type().name()));
        }
        if (dataAccessMethod.sorts() != null && dataAccessMethod.sorts().length > 0) {
            for (Annotation annotation : dataAccessMethod.sorts()) {
                sb.append(String.format("    queryModel.addSort(org.iternine.jeppetto.dao.SortDirection.%s, \"%s\");\n", annotation.direction().name(), annotation.field()));
            }
            sb.append('\n');
        }
        if (dataAccessMethod.limitResults()) {
            sb.append("    queryModel.setMaxResults(((Integer) argsIterator.next()).intValue());\n\n");
        }
        if (dataAccessMethod.skipResults()) {
            sb.append("    queryModel.setFirstResult(((Integer) argsIterator.next()).intValue());\n\n");
        }
        return dataAccessMethod.operation();
    }

    private static OperationType buildQueryModelFromMethodName(String methodName, StringBuilder sb) {
        String orderParts;
        String[] queryParts;
        boolean limitResults;
        OperationType operationType;
        String queryString;
        if (methodName.startsWith("findBy")) {
            queryString = methodName.substring("findBy".length(), methodName.length() - (methodName.endsWith("As") ? "As".length() : 0));
            operationType = OperationType.Read;
        } else if (methodName.startsWith("countBy")) {
            sb.append("    queryModel.setProjection(buildProjection(\"\", org.iternine.jeppetto.dao.ProjectionType.RowCount, argsIterator));\n\n");
            queryString = methodName.substring("countBy".length(), methodName.length() - (methodName.endsWith("As") ? "As".length() : 0));
            operationType = OperationType.Read;
        } else if (methodName.startsWith("updateBy")) {
            queryString = methodName.substring("updateBy".length(), methodName.length() - (methodName.endsWith("As") ? "As".length() : 0));
            operationType = OperationType.Update;
            sb.append("    org.iternine.jeppetto.dao.updateobject.UpdateObject updateObject = (org.iternine.jeppetto.dao.updateobject.UpdateObject) argsIterator.next();\n\n");
        } else if (methodName.startsWith("deleteBy")) {
            queryString = methodName.substring("deleteBy".length(), methodName.length() - (methodName.endsWith("As") ? "As".length() : 0));
            operationType = OperationType.Delete;
        } else {
            throw new UnsupportedOperationException("Don't know how to handle '" + methodName + "'");
        }
        int orderByIndex = queryString.indexOf("OrderBy");
        boolean skipResults = queryString.endsWith("AndSkip");
        if (skipResults) {
            queryString = queryString.substring(0, queryString.length() - "AndSkip".length());
        }
        if (limitResults = queryString.endsWith("AndLimit")) {
            queryString = queryString.substring(0, queryString.length() - "AndLimit".length());
        }
        if (orderByIndex == -1) {
            queryParts = queryString.split("Having");
            orderParts = null;
        } else {
            queryParts = queryString.substring(0, orderByIndex).split("Having");
            orderParts = queryString.substring(orderByIndex + "OrderBy".length());
        }
        if (queryParts != null) {
            if (queryParts[0].length() > 0) {
                String[] conditionStrings;
                for (String conditionString : conditionStrings = queryParts[0].split("And")) {
                    String conditionName = DAOBuilder.getConditionNameFromString(conditionString);
                    sb.append(String.format("    queryModel.addCondition(buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", DAOBuilder.pruneFieldNameFromString(conditionString, conditionName), conditionName));
                }
                sb.append('\n');
            }
            for (int i = 1; i < queryParts.length; ++i) {
                String[] conditionStrings;
                String associationString = queryParts[i];
                int withIndex = associationString.indexOf("With");
                for (String conditionString : conditionStrings = associationString.substring(withIndex + 4, associationString.length()).split("And")) {
                    String conditionName = DAOBuilder.getConditionNameFromString(conditionString);
                    sb.append(String.format("    queryModel.addAssociationCondition(\"%s\", buildCondition(\"%s\", org.iternine.jeppetto.dao.ConditionType.%s, argsIterator));\n", Character.toLowerCase(associationString.charAt(0)) + associationString.substring(1, withIndex), DAOBuilder.pruneFieldNameFromString(conditionString, conditionName), conditionName));
                }
                sb.append('\n');
            }
        }
        if (orderParts != null && operationType == OperationType.Read) {
            for (String orderPart : orderParts.split("And")) {
                String fieldName;
                SortDirection sortDirection;
                if (orderPart.endsWith("Desc")) {
                    sortDirection = SortDirection.Descending;
                    fieldName = DAOBuilder.pruneFieldNameFromString(orderPart, "Desc");
                } else {
                    sortDirection = SortDirection.Ascending;
                    fieldName = DAOBuilder.pruneFieldNameFromString(orderPart, "Asc");
                }
                sb.append(String.format("    queryModel.addSort(org.iternine.jeppetto.dao.SortDirection.%s, \"%s\");\n", sortDirection.name(), fieldName));
            }
            sb.append('\n');
        }
        if (limitResults) {
            sb.append("    queryModel.setMaxResults(((Integer) argsIterator.next()).intValue());\n\n");
        }
        if (skipResults) {
            sb.append("    queryModel.setFirstResult(((Integer) argsIterator.next()).intValue());\n\n");
        }
        return operationType;
    }

    private static String getConditionNameFromString(String conditionString) {
        for (ConditionType conditionType : ConditionType.values()) {
            if (!conditionString.endsWith(conditionType.name())) continue;
            return conditionType.name();
        }
        return ConditionType.Equal.name();
    }

    private static String pruneFieldNameFromString(String conditionString, String trailingPart) {
        StringBuilder fieldName = new StringBuilder();
        if (conditionString.endsWith(trailingPart)) {
            fieldName.append(conditionString.substring(0, conditionString.length() - trailingPart.length()));
        } else {
            fieldName.append(conditionString);
        }
        fieldName.setCharAt(0, Character.toLowerCase(conditionString.charAt(0)));
        return fieldName.toString();
    }

    private static <T> void buildReturnClause(CtMethod method, StringBuilder sb, Class<T> modelClass) {
        try {
            String returnTypeName = method.getReturnType().getName();
            if (modelClass.getName().equals(returnTypeName)) {
                if (method.getExceptionTypes().length > 0) {
                    sb.append("\n    return ($r) findUniqueUsingQueryModel(queryModel);");
                } else {
                    sb.append("    try {\n        return ($r) findUniqueUsingQueryModel(queryModel);\n    } catch (org.iternine.jeppetto.dao.NoSuchItemException e) {\n        return null;\n    }");
                }
            } else if ("java.util.Set".equals(returnTypeName)) {
                sb.append("    java.util.Set result = new java.util.HashSet();\n    for (java.util.Iterator iterator = findUsingQueryModel(queryModel).iterator(); iterator.hasNext(); ) {\n        result.add(iterator.next());\n    }\n     \n    return result;");
            } else if ("java.util.List".equals(returnTypeName) || "java.util.Collection".equals(returnTypeName)) {
                sb.append("    java.util.List result = new java.util.ArrayList();\n    for (java.util.Iterator iterator = findUsingQueryModel(queryModel).iterator(); iterator.hasNext(); ) {\n        result.add(iterator.next());\n    }\n     \n    return result;");
            } else if ("java.lang.Iterable".equals(returnTypeName)) {
                sb.append("\n    return findUsingQueryModel(queryModel);");
            } else if ("int".equals(returnTypeName)) {
                sb.append("\n    return ((Number) projectUsingQueryModel(queryModel)).intValue();");
            } else if ("long".equals(returnTypeName)) {
                sb.append("\n    return ((Number) projectUsingQueryModel(queryModel)).longValue();");
            } else {
                sb.append("\n    return ($r) projectUsingQueryModel(queryModel);");
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void buildUpdateClause(StringBuilder sb) {
        sb.append("\n    return updateUsingQueryModel(updateObject, queryModel);");
    }

    private static void buildDeleteClause(StringBuilder sb) {
        sb.append("\n    deleteUsingQueryModel(queryModel);");
    }

    private static void logDerivedMethod(CtMethod interfaceMethod, StringBuilder sb) {
        try {
            String parameters = "";
            String exceptions = "\n        throws ";
            int parameterCount = 0;
            for (CtClass parameterType : interfaceMethod.getParameterTypes()) {
                if (parameters.length() > 0) {
                    parameters = parameters + ", ";
                }
                parameters = parameters + parameterType.getSimpleName() + " a" + parameterCount++;
            }
            for (CtClass exceptionType : interfaceMethod.getExceptionTypes()) {
                exceptions = exceptions + exceptionType.getSimpleName();
            }
            logger.debug(String.format("Adding DAO method implementation: \n\npublic %s %s(%s) %s %s\n\n", interfaceMethod.getReturnType().getSimpleName(), interfaceMethod.getName(), parameters, exceptions.length() > 17 ? exceptions : "", sb.toString()));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

