/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.persistable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.persistable.Persistable;

public class PersistableList
implements Persistable,
List {
    private List delegate;
    private boolean rewrite = false;
    private Set<Integer> modifiedIndexes = new HashSet<Integer>();
    private int firstAppendedIndex;
    private boolean modifiableDelegate;
    private String storeIdentifier;

    public PersistableList() {
        this(new ArrayList(), false);
    }

    public PersistableList(int initialCapacity) {
        this(new ArrayList(initialCapacity), false);
    }

    public PersistableList(List delegate, boolean modifiableDelegate) {
        this.delegate = delegate;
        this.firstAppendedIndex = delegate.size();
        this.modifiableDelegate = modifiableDelegate;
    }

    @Override
    public boolean __isDirty() {
        return this.rewrite || this.delegate.size() > this.firstAppendedIndex || !this.modifiedIndexes.isEmpty() || this.__getDirtyFields().hasNext();
    }

    @Override
    public void __markPersisted(String storeIdentifier) {
        for (Object object : this.delegate) {
            if (!(object instanceof Persistable)) continue;
            Persistable persistable = (Persistable)object;
            persistable.__markPersisted(storeIdentifier);
        }
        this.rewrite = false;
        this.modifiedIndexes.clear();
        this.firstAppendedIndex = this.delegate.size();
        this.storeIdentifier = storeIdentifier;
    }

    @Override
    public boolean __isPersisted(String storeIdentifier) {
        return storeIdentifier.equals(this.storeIdentifier);
    }

    @Override
    public Iterator<String> __getDirtyFields() {
        return new Iterator<String>(){
            private Iterator delegateIterator;
            private int i;
            {
                this.delegateIterator = PersistableList.this.delegate.iterator();
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                while (this.delegateIterator.hasNext()) {
                    Object object = this.delegateIterator.next();
                    if (++this.i < PersistableList.this.firstAppendedIndex && !PersistableList.this.modifiedIndexes.contains(this.i) && object instanceof Persistable && !((Persistable)object).__isDirty()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                return Integer.toString(this.i);
            }

            @Override
            public void remove() {
                throw new JeppettoException("Can't remove items from dirtyKeys");
            }
        };
    }

    @Override
    public Object __getDelegate() {
        return this.delegate;
    }

    public void add(int index, Object element) {
        this.rewrite |= index < this.delegate.size();
        this.delegate.add(index, element);
    }

    public boolean addAll(int index, Collection elements) {
        this.rewrite |= index < this.delegate.size();
        return this.delegate.addAll(index, elements);
    }

    public Object remove(int index) {
        Object removed = this.delegate.remove(index);
        this.rewrite |= index < this.firstAppendedIndex;
        return removed;
    }

    public Object get(int index) {
        Object element = this.delegate.get(index);
        return element;
    }

    public Object set(int index, Object element) {
        if (index < this.firstAppendedIndex) {
            this.modifiedIndexes.add(index);
        }
        return this.delegate.set(index, element);
    }

    @Override
    public boolean add(Object element) {
        return this.delegate.add(element);
    }

    @Override
    public boolean addAll(Collection elements) {
        return this.delegate.addAll(elements);
    }

    @Override
    public boolean remove(Object element) {
        boolean changed = this.delegate.remove(element);
        this.rewrite |= changed;
        return changed;
    }

    @Override
    public boolean removeAll(Collection elements) {
        boolean changed = this.delegate.removeAll(elements);
        this.rewrite |= changed;
        return changed;
    }

    @Override
    public boolean retainAll(Collection elements) {
        boolean changed = this.delegate.retainAll(elements);
        this.rewrite |= changed;
        return changed;
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection elements) {
        return this.delegate.containsAll(elements);
    }

    @Override
    public int indexOf(Object element) {
        return this.delegate.indexOf(element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.delegate.lastIndexOf(element);
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private ListIterator delegateIterator;
            private int modifiableIndex;
            {
                this.delegateIterator = PersistableList.this.delegate.listIterator(index);
                this.modifiableIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Object next() {
                this.modifiableIndex = this.delegateIterator.nextIndex();
                Object next = this.delegateIterator.next();
                return next;
            }

            @Override
            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            public Object previous() {
                this.modifiableIndex = this.delegateIterator.previousIndex();
                Object previous = this.delegateIterator.previous();
                return previous;
            }

            @Override
            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                PersistableList.this.rewrite = (byte)(PersistableList.this.rewrite | (this.modifiableIndex < PersistableList.this.firstAppendedIndex ? 1 : 0));
            }

            public void set(Object o) {
                this.delegateIterator.set(o);
                PersistableList.this.modifiedIndexes.add(this.modifiableIndex);
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return this.delegate.toArray(objects);
    }

    @Override
    public void clear() {
        this.rewrite = true;
        this.delegate.clear();
    }

    public boolean isRewrite() {
        return this.rewrite;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List thatList = o instanceof PersistableList ? ((PersistableList)o).delegate : (List)o;
        return this.delegate.equals(thatList);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }
}

