/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.Condition;
import org.iternine.jeppetto.dao.Projection;
import org.iternine.jeppetto.dao.Sort;
import org.iternine.jeppetto.dao.SortDirection;

public class QueryModel {
    private List<Condition> conditions;
    private Map<String, List<Condition>> associationConditions = new LinkedHashMap<String, List<Condition>>();
    private List<Sort> sorts;
    private Projection projection;
    private int maxResults = -1;
    private int firstResult = -1;
    private AccessControlContext accessControlContext;

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(Condition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(condition);
    }

    public Map<String, List<Condition>> getAssociationConditions() {
        return this.associationConditions;
    }

    public void setAssociationConditions(Map<String, List<Condition>> associationConditions) {
        this.associationConditions = associationConditions;
    }

    public void addAssociationCondition(String associationField, Condition condition) {
        List<Condition> conditions = this.associationConditions.get(associationField);
        if (conditions == null) {
            conditions = new ArrayList<Condition>();
            this.associationConditions.put(associationField, conditions);
        }
        conditions.add(condition);
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<Sort> sorts) {
        this.sorts = sorts;
    }

    public void addSort(SortDirection sortDirection, String sortField) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<Sort>(1);
        }
        this.sorts.add(new Sort(sortField, sortDirection));
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    public void setAccessControlContext(AccessControlContext accessControlContext) {
        this.accessControlContext = accessControlContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryModel that = (QueryModel)o;
        return !(this.firstResult != that.firstResult || this.maxResults != that.maxResults || (this.accessControlContext == null ? that.accessControlContext != null : !this.accessControlContext.equals(that.accessControlContext)) || (this.associationConditions == null ? that.associationConditions != null : !this.associationConditions.equals(that.associationConditions)) || (this.conditions == null ? that.conditions != null : !this.conditions.equals(that.conditions)) || (this.projection == null ? that.projection != null : !this.projection.equals(that.projection)) || (this.sorts == null ? that.sorts != null : !this.sorts.equals(that.sorts)));
    }

    public int hashCode() {
        int result = this.conditions != null ? this.conditions.hashCode() : 0;
        result = 31 * result + (this.associationConditions != null ? this.associationConditions.hashCode() : 0);
        result = 31 * result + (this.sorts != null ? this.sorts.hashCode() : 0);
        result = 31 * result + (this.projection != null ? this.projection.hashCode() : 0);
        result = 31 * result + this.maxResults;
        result = 31 * result + this.firstResult;
        result = 31 * result + (this.accessControlContext != null ? this.accessControlContext.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryModel {");
        sb.append("\n  conditions=").append(this.conditions);
        sb.append("\n  associationConditions=").append(this.associationConditions);
        sb.append("\n  sorts=").append(this.sorts);
        sb.append("\n  projection=").append(this.projection);
        sb.append("\n  maxResults=").append(this.maxResults);
        sb.append("\n  firstResult=").append(this.firstResult);
        sb.append("\n  accessControlContext=").append(this.accessControlContext);
        sb.append("\n}");
        return sb.toString();
    }
}

